---
layout: default
title: serverless resource scans
nav_order: 1
---

# serverless resource scans (auto generated)

|    | Id         | Type     | Entity         | Policy                                                                              | IaC        | Resource Link                                                                                                                                       |
|----|------------|----------|----------------|-------------------------------------------------------------------------------------|------------|-----------------------------------------------------------------------------------------------------------------------------------------------------|
|  0 | CKV_AWS_1  | resource | serverless_aws | Ensure IAM policies that allow full "*-*" administrative privileges are not created | serverless | [AdminPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/serverless/checks/function/aws/AdminPolicyDocument.py)           |
|  1 | CKV_AWS_41 | resource | serverless_aws | Ensure no hard coded AWS access key and secret key exists in provider               | serverless | [AWSCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/serverless/checks/function/aws/AWSCredentials.py)                     |
|  2 | CKV_AWS_49 | resource | serverless_aws | Ensure no IAM policies documents allow "*" as a statement's actions                 | serverless | [StarActionPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/serverless/checks/function/aws/StarActionPolicyDocument.py) |


---


|      | Id          | Type     | Entity                                                           | Policy                                                                                                                                                                                                   | IaC            | Resource Link                                                                                                                                                                                                         |
|------|-------------|----------|------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|    0 | CKV_AWS_2   | resource | AWS::ElasticLoadBalancingV2::Listener                            | Ensure ALB protocol is HTTPS                                                                                                                                                                             | Cloudformation | [ALBListenerHTTPS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ALBListenerHTTPS.py)                                                                               |
|    1 | CKV_AWS_3   | resource | AWS::EC2::Volume                                                 | Ensure all data stored in the EBS is securely encrypted                                                                                                                                                  | Cloudformation | [EBSEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/EBSEncryption.py)                                                                                     |
|    2 | CKV_AWS_5   | resource | AWS::Elasticsearch::Domain                                       | Ensure all data stored in the Elasticsearch is securely encrypted at rest                                                                                                                                | Cloudformation | [ElasticsearchEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ElasticsearchEncryption.py)                                                                 |
|    3 | CKV_AWS_6   | resource | AWS::Elasticsearch::Domain                                       | Ensure all Elasticsearch has node-to-node encryption enabled                                                                                                                                             | Cloudformation | [ElasticsearchNodeToNodeEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ElasticsearchNodeToNodeEncryption.py)                                             |
|    4 | CKV_AWS_7   | resource | AWS::KMS::Key                                                    | Ensure rotation for customer created CMKs is enabled                                                                                                                                                     | Cloudformation | [KMSRotation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/KMSRotation.py)                                                                                         |
|    5 | CKV_AWS_8   | resource | AWS::AutoScaling::LaunchConfiguration                            | Ensure all data stored in the Launch configuration EBS is securely encrypted                                                                                                                             | Cloudformation | [LaunchConfigurationEBSEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LaunchConfigurationEBSEncryption.py)                                               |
|    6 | CKV_AWS_16  | resource | AWS::RDS::DBInstance                                             | Ensure all data stored in the RDS is securely encrypted at rest                                                                                                                                          | Cloudformation | [RDSEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/RDSEncryption.py)                                                                                     |
|    7 | CKV_AWS_17  | resource | AWS::RDS::DBInstance                                             | Ensure all data stored in RDS is not publicly accessible                                                                                                                                                 | Cloudformation | [RDSPubliclyAccessible.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/RDSPubliclyAccessible.py)                                                                     |
|    8 | CKV_AWS_18  | resource | AWS::S3::Bucket                                                  | Ensure the S3 bucket has access logging enabled                                                                                                                                                          | Cloudformation | [S3AccessLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/S3AccessLogs.py)                                                                                       |
|    9 | CKV_AWS_19  | resource | AWS::S3::Bucket                                                  | Ensure the S3 bucket has server-side-encryption enabled                                                                                                                                                  | Cloudformation | [S3Encryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/S3Encryption.py)                                                                                       |
|   10 | CKV_AWS_20  | resource | AWS::S3::Bucket                                                  | Ensure the S3 bucket does not allow READ permissions to everyone                                                                                                                                         | Cloudformation | [S3PublicACLRead.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/S3PublicACLRead.py)                                                                                 |
|   11 | CKV_AWS_21  | resource | AWS::S3::Bucket                                                  | Ensure the S3 bucket has versioning enabled                                                                                                                                                              | Cloudformation | [S3Versioning.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/S3Versioning.py)                                                                                       |
|   12 | CKV_AWS_23  | resource | AWS::EC2::SecurityGroup                                          | Ensure every security groups rule has a description                                                                                                                                                      | Cloudformation | [SecurityGroupRuleDescription.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SecurityGroupRuleDescription.py)                                                       |
|   13 | CKV_AWS_23  | resource | AWS::EC2::SecurityGroupEgress                                    | Ensure every security groups rule has a description                                                                                                                                                      | Cloudformation | [SecurityGroupRuleDescription.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SecurityGroupRuleDescription.py)                                                       |
|   14 | CKV_AWS_23  | resource | AWS::EC2::SecurityGroupIngress                                   | Ensure every security groups rule has a description                                                                                                                                                      | Cloudformation | [SecurityGroupRuleDescription.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SecurityGroupRuleDescription.py)                                                       |
|   15 | CKV_AWS_24  | resource | AWS::EC2::SecurityGroup                                          | Ensure no security groups allow ingress from 0.0.0.0:0 to port 22                                                                                                                                        | Cloudformation | [SecurityGroupUnrestrictedIngress22.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SecurityGroupUnrestrictedIngress22.py)                                           |
|   16 | CKV_AWS_24  | resource | AWS::EC2::SecurityGroupIngress                                   | Ensure no security groups allow ingress from 0.0.0.0:0 to port 22                                                                                                                                        | Cloudformation | [SecurityGroupUnrestrictedIngress22.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SecurityGroupUnrestrictedIngress22.py)                                           |
|   17 | CKV_AWS_25  | resource | AWS::EC2::SecurityGroup                                          | Ensure no security groups allow ingress from 0.0.0.0:0 to port 3389                                                                                                                                      | Cloudformation | [SecurityGroupUnrestrictedIngress3389.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SecurityGroupUnrestrictedIngress3389.py)                                       |
|   18 | CKV_AWS_25  | resource | AWS::EC2::SecurityGroupIngress                                   | Ensure no security groups allow ingress from 0.0.0.0:0 to port 3389                                                                                                                                      | Cloudformation | [SecurityGroupUnrestrictedIngress3389.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SecurityGroupUnrestrictedIngress3389.py)                                       |
|   19 | CKV_AWS_26  | resource | AWS::SNS::Topic                                                  | Ensure all data stored in the SNS topic is encrypted                                                                                                                                                     | Cloudformation | [SNSTopicEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SNSTopicEncryption.py)                                                                           |
|   20 | CKV_AWS_27  | resource | AWS::SQS::Queue                                                  | Ensure all data stored in the SQS queue is encrypted                                                                                                                                                     | Cloudformation | [SQSQueueEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SQSQueueEncryption.py)                                                                           |
|   21 | CKV_AWS_28  | resource | AWS::DynamoDB::Table                                             | Ensure DynamoDB point in time recovery (backup) is enabled                                                                                                                                               | Cloudformation | [DynamodbRecovery.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DynamodbRecovery.py)                                                                               |
|   22 | CKV_AWS_29  | resource | AWS::ElastiCache::ReplicationGroup                               | Ensure all data stored in the ElastiCache Replication Group is securely encrypted at rest                                                                                                                | Cloudformation | [ElasticacheReplicationGroupEncryptionAtRest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ElasticacheReplicationGroupEncryptionAtRest.py)                         |
|   23 | CKV_AWS_30  | resource | AWS::ElastiCache::ReplicationGroup                               | Ensure all data stored in the ElastiCache Replication Group is securely encrypted at transit                                                                                                             | Cloudformation | [ElasticacheReplicationGroupEncryptionAtTransit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ElasticacheReplicationGroupEncryptionAtTransit.py)                   |
|   24 | CKV_AWS_31  | resource | AWS::ElastiCache::ReplicationGroup                               | Ensure all data stored in the ElastiCache Replication Group is securely encrypted at transit and has auth token                                                                                          | Cloudformation | [ElasticacheReplicationGroupEncryptionAtTransitAuthToken.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ElasticacheReplicationGroupEncryptionAtTransitAuthToken.py) |
|   25 | CKV_AWS_32  | resource | AWS::ECR::Repository                                             | Ensure ECR policy is not set to public                                                                                                                                                                   | Cloudformation | [ECRPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ECRPolicy.py)                                                                                             |
|   26 | CKV_AWS_33  | resource | AWS::KMS::Key                                                    | Ensure KMS key policy does not contain wildcard (*) principal                                                                                                                                            | Cloudformation | [KMSKeyWildCardPrincipal.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/KMSKeyWildCardPrincipal.py)                                                                 |
|   27 | CKV_AWS_34  | resource | AWS::CloudFront::Distribution                                    | Ensure CloudFront Distribution ViewerProtocolPolicy is set to HTTPS                                                                                                                                      | Cloudformation | [CloudfrontDistributionEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/CloudfrontDistributionEncryption.py)                                               |
|   28 | CKV_AWS_35  | resource | AWS::CloudTrail::Trail                                           | Ensure CloudTrail logs are encrypted at rest using KMS CMKs                                                                                                                                              | Cloudformation | [CloudtrailEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/CloudtrailEncryption.py)                                                                       |
|   29 | CKV_AWS_36  | resource | AWS::CloudTrail::Trail                                           | Ensure CloudTrail log file validation is enabled                                                                                                                                                         | Cloudformation | [CloudtrailLogValidation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/CloudtrailLogValidation.py)                                                                 |
|   30 | CKV_AWS_40  | resource | AWS::IAM::Policy                                                 | Ensure IAM policies are attached only to groups or roles (Reducing access management complexity may in-turn reduce opportunity for a principal to inadvertently receive or retain excessive privileges.) | Cloudformation | [IAMPolicyAttachedToGroupOrRoles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMPolicyAttachedToGroupOrRoles.py)                                                 |
|   31 | CKV_AWS_42  | resource | AWS::EFS::FileSystem                                             | Ensure EFS is securely encrypted                                                                                                                                                                         | Cloudformation | [EFSEncryptionEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/EFSEncryptionEnabled.py)                                                                       |
|   32 | CKV_AWS_43  | resource | AWS::Kinesis::Stream                                             | Ensure Kinesis Stream is securely encrypted                                                                                                                                                              | Cloudformation | [KinesisStreamEncryptionType.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/KinesisStreamEncryptionType.py)                                                         |
|   33 | CKV_AWS_44  | resource | AWS::Neptune::DBCluster                                          | Ensure Neptune storage is securely encrypted                                                                                                                                                             | Cloudformation | [NeptuneClusterStorageEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/NeptuneClusterStorageEncrypted.py)                                                   |
|   34 | CKV_AWS_45  | resource | AWS::Lambda::Function                                            | Ensure no hard-coded secrets exist in Lambda environment                                                                                                                                                 | Cloudformation | [LambdaEnvironmentCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaEnvironmentCredentials.py)                                                       |
|   35 | CKV_AWS_45  | resource | AWS::Serverless::Function                                        | Ensure no hard-coded secrets exist in Lambda environment                                                                                                                                                 | Cloudformation | [LambdaEnvironmentCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaEnvironmentCredentials.py)                                                       |
|   36 | CKV_AWS_46  | resource | AWS::EC2::Instance                                               | Ensure no hard-coded secrets exist in EC2 user data                                                                                                                                                      | Cloudformation | [EC2Credentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/EC2Credentials.py)                                                                                   |
|   37 | CKV_AWS_47  | resource | AWS::DAX::Cluster                                                | Ensure DAX is encrypted at rest (default is unencrypted)                                                                                                                                                 | Cloudformation | [DAXEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DAXEncryption.py)                                                                                     |
|   38 | CKV_AWS_51  | resource | AWS::ECR::Repository                                             | Ensure ECR Image Tags are immutable                                                                                                                                                                      | Cloudformation | [ECRImmutableTags.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ECRImmutableTags.py)                                                                               |
|   39 | CKV_AWS_53  | resource | AWS::S3::Bucket                                                  | Ensure S3 bucket has block public ACLs enabled                                                                                                                                                           | Cloudformation | [S3BlockPublicACLs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/S3BlockPublicACLs.py)                                                                             |
|   40 | CKV_AWS_54  | resource | AWS::S3::Bucket                                                  | Ensure S3 bucket has block public policy enabled                                                                                                                                                         | Cloudformation | [S3BlockPublicPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/S3BlockPublicPolicy.py)                                                                         |
|   41 | CKV_AWS_55  | resource | AWS::S3::Bucket                                                  | Ensure S3 bucket has ignore public ACLs enabled                                                                                                                                                          | Cloudformation | [S3IgnorePublicACLs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/S3IgnorePublicACLs.py)                                                                           |
|   42 | CKV_AWS_56  | resource | AWS::S3::Bucket                                                  | Ensure S3 bucket has RestrictPublicBuckets enabled                                                                                                                                                       | Cloudformation | [S3RestrictPublicBuckets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/S3RestrictPublicBuckets.py)                                                                 |
|   43 | CKV_AWS_57  | resource | AWS::S3::Bucket                                                  | Ensure the S3 bucket does not allow WRITE permissions to everyone                                                                                                                                        | Cloudformation | [S3PublicACLWrite.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/S3PublicACLWrite.py)                                                                               |
|   44 | CKV_AWS_58  | resource | AWS::EKS::Cluster                                                | Ensure EKS Cluster has Secrets Encryption Enabled                                                                                                                                                        | Cloudformation | [EKSSecretsEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/EKSSecretsEncryption.py)                                                                       |
|   45 | CKV_AWS_59  | resource | AWS::ApiGateway::Method                                          | Ensure there is no open access to back-end resources through API                                                                                                                                         | Cloudformation | [APIGatewayAuthorization.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/APIGatewayAuthorization.py)                                                                 |
|   46 | CKV_AWS_60  | resource | AWS::IAM::Role                                                   | Ensure IAM role allows only specific services or principals to assume it                                                                                                                                 | Cloudformation | [IAMRoleAllowsPublicAssume.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMRoleAllowsPublicAssume.py)                                                             |
|   47 | CKV_AWS_61  | resource | AWS::IAM::Role                                                   | Ensure AWS IAM policy does not allow assume role permission across all services                                                                                                                          | Cloudformation | [IAMRoleAllowAssumeFromAccount.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMRoleAllowAssumeFromAccount.py)                                                     |
|   48 | CKV_AWS_62  | resource | AWS::IAM::Group                                                  | Ensure no IAM policies that allow full "*-*" administrative privileges are not created                                                                                                                   | Cloudformation | [IAMAdminPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMAdminPolicyDocument.py)                                                                   |
|   49 | CKV_AWS_62  | resource | AWS::IAM::Policy                                                 | Ensure no IAM policies that allow full "*-*" administrative privileges are not created                                                                                                                   | Cloudformation | [IAMAdminPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMAdminPolicyDocument.py)                                                                   |
|   50 | CKV_AWS_62  | resource | AWS::IAM::Role                                                   | Ensure no IAM policies that allow full "*-*" administrative privileges are not created                                                                                                                   | Cloudformation | [IAMAdminPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMAdminPolicyDocument.py)                                                                   |
|   51 | CKV_AWS_62  | resource | AWS::IAM::User                                                   | Ensure no IAM policies that allow full "*-*" administrative privileges are not created                                                                                                                   | Cloudformation | [IAMAdminPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMAdminPolicyDocument.py)                                                                   |
|   52 | CKV_AWS_63  | resource | AWS::IAM::Group                                                  | Ensure no IAM policies documents allow "*" as a statement's actions                                                                                                                                      | Cloudformation | [IAMStarActionPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMStarActionPolicyDocument.py)                                                         |
|   53 | CKV_AWS_63  | resource | AWS::IAM::Policy                                                 | Ensure no IAM policies documents allow "*" as a statement's actions                                                                                                                                      | Cloudformation | [IAMStarActionPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMStarActionPolicyDocument.py)                                                         |
|   54 | CKV_AWS_63  | resource | AWS::IAM::Role                                                   | Ensure no IAM policies documents allow "*" as a statement's actions                                                                                                                                      | Cloudformation | [IAMStarActionPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMStarActionPolicyDocument.py)                                                         |
|   55 | CKV_AWS_63  | resource | AWS::IAM::User                                                   | Ensure no IAM policies documents allow "*" as a statement's actions                                                                                                                                      | Cloudformation | [IAMStarActionPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMStarActionPolicyDocument.py)                                                         |
|   56 | CKV_AWS_64  | resource | AWS::Redshift::Cluster                                           | Ensure all data stored in the Redshift cluster is securely encrypted at rest                                                                                                                             | Cloudformation | [RedshiftClusterEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/RedshiftClusterEncryption.py)                                                             |
|   57 | CKV_AWS_65  | resource | AWS::ECS::Cluster                                                | Ensure container insights are enabled on ECS cluster                                                                                                                                                     | Cloudformation | [ECSClusterContainerInsights.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ECSClusterContainerInsights.py)                                                         |
|   58 | CKV_AWS_66  | resource | AWS::Logs::LogGroup                                              | Ensure that CloudWatch Log Group specifies retention days                                                                                                                                                | Cloudformation | [CloudWatchLogGroupRetention.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/CloudWatchLogGroupRetention.py)                                                         |
|   59 | CKV_AWS_67  | resource | AWS::CloudTrail::Trail                                           | Ensure CloudTrail is enabled in all Regions                                                                                                                                                              | Cloudformation | [CloudtrailMultiRegion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/CloudtrailMultiRegion.py)                                                                     |
|   60 | CKV_AWS_68  | resource | AWS::CloudFront::Distribution                                    | CloudFront Distribution should have WAF enabled                                                                                                                                                          | Cloudformation | [WAFEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/WAFEnabled.py)                                                                                           |
|   61 | CKV_AWS_69  | resource | AWS::AmazonMQ::Broker                                            | Ensure Amazon MQ Broker should not have public access                                                                                                                                                    | Cloudformation | [AmazonMQBrokerPublicAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/AmazonMQBrokerPublicAccess.py)                                                           |
|   62 | CKV_AWS_71  | resource | AWS::Redshift::Cluster                                           | Ensure Redshift Cluster logging is enabled                                                                                                                                                               | Cloudformation | [RedshiftClusterLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/RedshiftClusterLogging.py)                                                                   |
|   63 | CKV_AWS_73  | resource | AWS::ApiGateway::Stage                                           | Ensure API Gateway has X-Ray Tracing enabled                                                                                                                                                             | Cloudformation | [APIGatewayXray.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/APIGatewayXray.py)                                                                                   |
|   64 | CKV_AWS_73  | resource | AWS::Serverless::Api                                             | Ensure API Gateway has X-Ray Tracing enabled                                                                                                                                                             | Cloudformation | [APIGatewayXray.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/APIGatewayXray.py)                                                                                   |
|   65 | CKV_AWS_74  | resource | AWS::DocDB::DBCluster                                            | Ensure DocumentDB is encrypted at rest (default is unencrypted)                                                                                                                                          | Cloudformation | [DocDBEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DocDBEncryption.py)                                                                                 |
|   66 | CKV_AWS_76  | resource | AWS::ApiGateway::Stage                                           | Ensure API Gateway has Access Logging enabled                                                                                                                                                            | Cloudformation | [APIGatewayAccessLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/APIGatewayAccessLogging.py)                                                                 |
|   67 | CKV_AWS_76  | resource | AWS::Serverless::Api                                             | Ensure API Gateway has Access Logging enabled                                                                                                                                                            | Cloudformation | [APIGatewayAccessLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/APIGatewayAccessLogging.py)                                                                 |
|   68 | CKV_AWS_78  | resource | AWS::CodeBuild::Project                                          | Ensure that CodeBuild Project encryption is not disabled                                                                                                                                                 | Cloudformation | [CodeBuildProjectEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/CodeBuildProjectEncryption.py)                                                           |
|   69 | CKV_AWS_79  | resource | AWS::EC2::LaunchTemplate                                         | Ensure Instance Metadata Service Version 1 is not enabled                                                                                                                                                | Cloudformation | [IMDSv1Disabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IMDSv1Disabled.py)                                                                                   |
|   70 | CKV_AWS_80  | resource | AWS::MSK::Cluster                                                | Ensure MSK Cluster logging is enabled                                                                                                                                                                    | Cloudformation | [MSKClusterLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/MSKClusterLogging.py)                                                                             |
|   71 | CKV_AWS_81  | resource | AWS::MSK::Cluster                                                | Ensure MSK Cluster encryption in rest and transit is enabled                                                                                                                                             | Cloudformation | [MSKClusterEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/MSKClusterEncryption.py)                                                                       |
|   72 | CKV_AWS_82  | resource | AWS::Athena::WorkGroup                                           | Ensure Athena Workgroup should enforce configuration to prevent client disabling encryption                                                                                                              | Cloudformation | [AthenaWorkgroupConfiguration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/AthenaWorkgroupConfiguration.py)                                                       |
|   73 | CKV_AWS_83  | resource | AWS::Elasticsearch::Domain                                       | Ensure Elasticsearch Domain enforces HTTPS                                                                                                                                                               | Cloudformation | [ElasticsearchDomainEnforceHTTPS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ElasticsearchDomainEnforceHTTPS.py)                                                 |
|   74 | CKV_AWS_84  | resource | AWS::Elasticsearch::Domain                                       | Ensure Elasticsearch Domain Logging is enabled                                                                                                                                                           | Cloudformation | [ElasticsearchDomainLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ElasticsearchDomainLogging.py)                                                           |
|   75 | CKV_AWS_84  | resource | AWS::OpenSearchService::Domain                                   | Ensure Elasticsearch Domain Logging is enabled                                                                                                                                                           | Cloudformation | [ElasticsearchDomainLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ElasticsearchDomainLogging.py)                                                           |
|   76 | CKV_AWS_85  | resource | AWS::DocDB::DBCluster                                            | Ensure DocumentDB Logging is enabled                                                                                                                                                                     | Cloudformation | [DocDBLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DocDBLogging.py)                                                                                       |
|   77 | CKV_AWS_86  | resource | AWS::CloudFront::Distribution                                    | Ensure CloudFront Distribution has Access Logging enabled                                                                                                                                                | Cloudformation | [CloudfrontDistributionLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/CloudfrontDistributionLogging.py)                                                     |
|   78 | CKV_AWS_87  | resource | AWS::Redshift::Cluster                                           | Redshift cluster should not be publicly accessible                                                                                                                                                       | Cloudformation | [RedshiftClusterPubliclyAccessible.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/RedshiftClusterPubliclyAccessible.py)                                             |
|   79 | CKV_AWS_88  | resource | AWS::EC2::Instance                                               | EC2 instance should not have public IP.                                                                                                                                                                  | Cloudformation | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/EC2PublicIP.py)                                                                                         |
|   80 | CKV_AWS_88  | resource | AWS::EC2::LaunchTemplate                                         | EC2 instance should not have public IP.                                                                                                                                                                  | Cloudformation | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/EC2PublicIP.py)                                                                                         |
|   81 | CKV_AWS_89  | resource | AWS::DMS::ReplicationInstance                                    | DMS replication instance should not be publicly accessible                                                                                                                                               | Cloudformation | [DMSReplicationInstancePubliclyAccessible.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DMSReplicationInstancePubliclyAccessible.py)                               |
|   82 | CKV_AWS_90  | resource | AWS::DocDB::DBClusterParameterGroup                              | Ensure DocumentDB TLS is not disabled                                                                                                                                                                    | Cloudformation | [DocDBTLS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DocDBTLS.py)                                                                                               |
|   83 | CKV_AWS_91  | resource | AWS::ElasticLoadBalancingV2::LoadBalancer                        | Ensure the ELBv2 (Application/Network) has access logging enabled                                                                                                                                        | Cloudformation | [ELBv2AccessLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ELBv2AccessLogs.py)                                                                                 |
|   84 | CKV_AWS_92  | resource | AWS::ElasticLoadBalancing::LoadBalancer                          | Ensure the ELB has access logging enabled                                                                                                                                                                | Cloudformation | [ELBAccessLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ELBAccessLogs.py)                                                                                     |
|   85 | CKV_AWS_94  | resource | AWS::Glue::DataCatalogEncryptionSettings                         | Ensure Glue Data Catalog Encryption is enabled                                                                                                                                                           | Cloudformation | [GlueDataCatalogEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/GlueDataCatalogEncryption.py)                                                             |
|   86 | CKV_AWS_95  | resource | AWS::ApiGatewayV2::Stage                                         | Ensure API Gateway V2 has Access Logging enabled                                                                                                                                                         | Cloudformation | [APIGatewayV2AccessLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/APIGatewayV2AccessLogging.py)                                                             |
|   87 | CKV_AWS_95  | resource | AWS::Serverless::HttpApi                                         | Ensure API Gateway V2 has Access Logging enabled                                                                                                                                                         | Cloudformation | [APIGatewayV2AccessLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/APIGatewayV2AccessLogging.py)                                                             |
|   88 | CKV_AWS_96  | resource | AWS::RDS::DBCluster                                              | Ensure all data stored in Aurora is securely encrypted at rest                                                                                                                                           | Cloudformation | [AuroraEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/AuroraEncryption.py)                                                                               |
|   89 | CKV_AWS_97  | resource | AWS::ECS::TaskDefinition                                         | Ensure Encryption in transit is enabled for EFS volumes in ECS Task definitions                                                                                                                          | Cloudformation | [ECSTaskDefinitionEFSVolumeEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ECSTaskDefinitionEFSVolumeEncryption.py)                                       |
|   90 | CKV_AWS_99  | resource | AWS::Glue::SecurityConfiguration                                 | Ensure Glue Security Configuration Encryption is enabled                                                                                                                                                 | Cloudformation | [GlueSecurityConfiguration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/GlueSecurityConfiguration.py)                                                             |
|   91 | CKV_AWS_100 | resource | AWS::EKS::Nodegroup                                              | Ensure AWS EKS node group does not have implicit SSH access from 0.0.0.0/0                                                                                                                               | Cloudformation | [EKSNodeGroupRemoteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/EKSNodeGroupRemoteAccess.py)                                                               |
|   92 | CKV_AWS_101 | resource | AWS::Neptune::DBCluster                                          | Ensure Neptune logging is enabled                                                                                                                                                                        | Cloudformation | [NeptuneClusterLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/NeptuneClusterLogging.py)                                                                     |
|   93 | CKV_AWS_103 | resource | AWS::ElasticLoadBalancingV2::Listener                            | Ensure that Load Balancer Listener is using at least TLS v1.2                                                                                                                                            | Cloudformation | [ALBListenerTLS12.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ALBListenerTLS12.py)                                                                               |
|   94 | CKV_AWS_104 | resource | AWS::DocDB::DBClusterParameterGroup                              | Ensure DocumentDB has audit logs enabled                                                                                                                                                                 | Cloudformation | [DocDBAuditLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DocDBAuditLogs.py)                                                                                   |
|   95 | CKV_AWS_105 | resource | AWS::Redshift::ClusterParameterGroup                             | Ensure Redshift uses SSL                                                                                                                                                                                 | Cloudformation | [RedShiftSSL.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/RedShiftSSL.py)                                                                                         |
|   96 | CKV_AWS_107 | resource | AWS::IAM::Group                                                  | Ensure IAM policies does not allow credentials exposure                                                                                                                                                  | Cloudformation | [IAMCredentialsExposure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMCredentialsExposure.py)                                                                   |
|   97 | CKV_AWS_107 | resource | AWS::IAM::ManagedPolicy                                          | Ensure IAM policies does not allow credentials exposure                                                                                                                                                  | Cloudformation | [IAMCredentialsExposure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMCredentialsExposure.py)                                                                   |
|   98 | CKV_AWS_107 | resource | AWS::IAM::Policy                                                 | Ensure IAM policies does not allow credentials exposure                                                                                                                                                  | Cloudformation | [IAMCredentialsExposure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMCredentialsExposure.py)                                                                   |
|   99 | CKV_AWS_107 | resource | AWS::IAM::Role                                                   | Ensure IAM policies does not allow credentials exposure                                                                                                                                                  | Cloudformation | [IAMCredentialsExposure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMCredentialsExposure.py)                                                                   |
|  100 | CKV_AWS_107 | resource | AWS::IAM::User                                                   | Ensure IAM policies does not allow credentials exposure                                                                                                                                                  | Cloudformation | [IAMCredentialsExposure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMCredentialsExposure.py)                                                                   |
|  101 | CKV_AWS_108 | resource | AWS::IAM::Group                                                  | Ensure IAM policies does not allow data exfiltration                                                                                                                                                     | Cloudformation | [IAMDataExfiltration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMDataExfiltration.py)                                                                         |
|  102 | CKV_AWS_108 | resource | AWS::IAM::ManagedPolicy                                          | Ensure IAM policies does not allow data exfiltration                                                                                                                                                     | Cloudformation | [IAMDataExfiltration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMDataExfiltration.py)                                                                         |
|  103 | CKV_AWS_108 | resource | AWS::IAM::Policy                                                 | Ensure IAM policies does not allow data exfiltration                                                                                                                                                     | Cloudformation | [IAMDataExfiltration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMDataExfiltration.py)                                                                         |
|  104 | CKV_AWS_108 | resource | AWS::IAM::Role                                                   | Ensure IAM policies does not allow data exfiltration                                                                                                                                                     | Cloudformation | [IAMDataExfiltration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMDataExfiltration.py)                                                                         |
|  105 | CKV_AWS_108 | resource | AWS::IAM::User                                                   | Ensure IAM policies does not allow data exfiltration                                                                                                                                                     | Cloudformation | [IAMDataExfiltration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMDataExfiltration.py)                                                                         |
|  106 | CKV_AWS_109 | resource | AWS::IAM::Group                                                  | Ensure IAM policies does not allow permissions management without constraints                                                                                                                            | Cloudformation | [IAMPermissionsManagement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMPermissionsManagement.py)                                                               |
|  107 | CKV_AWS_109 | resource | AWS::IAM::ManagedPolicy                                          | Ensure IAM policies does not allow permissions management without constraints                                                                                                                            | Cloudformation | [IAMPermissionsManagement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMPermissionsManagement.py)                                                               |
|  108 | CKV_AWS_109 | resource | AWS::IAM::Policy                                                 | Ensure IAM policies does not allow permissions management without constraints                                                                                                                            | Cloudformation | [IAMPermissionsManagement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMPermissionsManagement.py)                                                               |
|  109 | CKV_AWS_109 | resource | AWS::IAM::Role                                                   | Ensure IAM policies does not allow permissions management without constraints                                                                                                                            | Cloudformation | [IAMPermissionsManagement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMPermissionsManagement.py)                                                               |
|  110 | CKV_AWS_109 | resource | AWS::IAM::User                                                   | Ensure IAM policies does not allow permissions management without constraints                                                                                                                            | Cloudformation | [IAMPermissionsManagement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMPermissionsManagement.py)                                                               |
|  111 | CKV_AWS_110 | resource | AWS::IAM::Group                                                  | Ensure IAM policies does not allow privilege escalation                                                                                                                                                  | Cloudformation | [IAMPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMPrivilegeEscalation.py)                                                                   |
|  112 | CKV_AWS_110 | resource | AWS::IAM::ManagedPolicy                                          | Ensure IAM policies does not allow privilege escalation                                                                                                                                                  | Cloudformation | [IAMPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMPrivilegeEscalation.py)                                                                   |
|  113 | CKV_AWS_110 | resource | AWS::IAM::Policy                                                 | Ensure IAM policies does not allow privilege escalation                                                                                                                                                  | Cloudformation | [IAMPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMPrivilegeEscalation.py)                                                                   |
|  114 | CKV_AWS_110 | resource | AWS::IAM::Role                                                   | Ensure IAM policies does not allow privilege escalation                                                                                                                                                  | Cloudformation | [IAMPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMPrivilegeEscalation.py)                                                                   |
|  115 | CKV_AWS_110 | resource | AWS::IAM::User                                                   | Ensure IAM policies does not allow privilege escalation                                                                                                                                                  | Cloudformation | [IAMPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMPrivilegeEscalation.py)                                                                   |
|  116 | CKV_AWS_111 | resource | AWS::IAM::Group                                                  | Ensure IAM policies does not allow write access without constraints                                                                                                                                      | Cloudformation | [IAMWriteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMWriteAccess.py)                                                                                   |
|  117 | CKV_AWS_111 | resource | AWS::IAM::ManagedPolicy                                          | Ensure IAM policies does not allow write access without constraints                                                                                                                                      | Cloudformation | [IAMWriteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMWriteAccess.py)                                                                                   |
|  118 | CKV_AWS_111 | resource | AWS::IAM::Policy                                                 | Ensure IAM policies does not allow write access without constraints                                                                                                                                      | Cloudformation | [IAMWriteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMWriteAccess.py)                                                                                   |
|  119 | CKV_AWS_111 | resource | AWS::IAM::Role                                                   | Ensure IAM policies does not allow write access without constraints                                                                                                                                      | Cloudformation | [IAMWriteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMWriteAccess.py)                                                                                   |
|  120 | CKV_AWS_111 | resource | AWS::IAM::User                                                   | Ensure IAM policies does not allow write access without constraints                                                                                                                                      | Cloudformation | [IAMWriteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/IAMWriteAccess.py)                                                                                   |
|  121 | CKV_AWS_115 | resource | AWS::Lambda::Function                                            | Ensure that AWS Lambda function is configured for function-level concurrent execution limit                                                                                                              | Cloudformation | [LambdaFunctionLevelConcurrentExecutionLimit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaFunctionLevelConcurrentExecutionLimit.py)                         |
|  122 | CKV_AWS_115 | resource | AWS::Serverless::Function                                        | Ensure that AWS Lambda function is configured for function-level concurrent execution limit                                                                                                              | Cloudformation | [LambdaFunctionLevelConcurrentExecutionLimit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaFunctionLevelConcurrentExecutionLimit.py)                         |
|  123 | CKV_AWS_116 | resource | AWS::Lambda::Function                                            | Ensure that AWS Lambda function is configured for a Dead Letter Queue(DLQ)                                                                                                                               | Cloudformation | [LambdaDLQConfigured.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaDLQConfigured.py)                                                                         |
|  124 | CKV_AWS_116 | resource | AWS::Serverless::Function                                        | Ensure that AWS Lambda function is configured for a Dead Letter Queue(DLQ)                                                                                                                               | Cloudformation | [LambdaDLQConfigured.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaDLQConfigured.py)                                                                         |
|  125 | CKV_AWS_117 | resource | AWS::Lambda::Function                                            | Ensure that AWS Lambda function is configured inside a VPC                                                                                                                                               | Cloudformation | [LambdaInVPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaInVPC.py)                                                                                         |
|  126 | CKV_AWS_117 | resource | AWS::Serverless::Function                                        | Ensure that AWS Lambda function is configured inside a VPC                                                                                                                                               | Cloudformation | [LambdaInVPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaInVPC.py)                                                                                         |
|  127 | CKV_AWS_118 | resource | AWS::RDS::DBInstance                                             | Ensure that enhanced monitoring is enabled for Amazon RDS instances                                                                                                                                      | Cloudformation | [RDSEnhancedMonitorEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/RDSEnhancedMonitorEnabled.py)                                                             |
|  128 | CKV_AWS_119 | resource | AWS::DynamoDB::Table                                             | Ensure DynamoDB Tables are encrypted using a KMS Customer Managed CMK                                                                                                                                    | Cloudformation | [DynamoDBTablesEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DynamoDBTablesEncrypted.py)                                                                 |
|  129 | CKV_AWS_120 | resource | AWS::ApiGateway::Stage                                           | Ensure API Gateway caching is enabled                                                                                                                                                                    | Cloudformation | [APIGatewayCacheEnable.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/APIGatewayCacheEnable.py)                                                                     |
|  130 | CKV_AWS_120 | resource | AWS::Serverless::Api                                             | Ensure API Gateway caching is enabled                                                                                                                                                                    | Cloudformation | [APIGatewayCacheEnable.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/APIGatewayCacheEnable.py)                                                                     |
|  131 | CKV_AWS_123 | resource | AWS::EC2::VPCEndpointService                                     | Ensure that VPC Endpoint Service is configured for Manual Acceptance                                                                                                                                     | Cloudformation | [VPCEndpointAcceptanceConfigured.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/VPCEndpointAcceptanceConfigured.py)                                                 |
|  132 | CKV_AWS_131 | resource | AWS::ElasticLoadBalancingV2::LoadBalancer                        | Ensure that ALB drops HTTP headers                                                                                                                                                                       | Cloudformation | [ALBDropHttpHeaders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ALBDropHttpHeaders.py)                                                                           |
|  133 | CKV_AWS_136 | resource | AWS::ECR::Repository                                             | Ensure that ECR repositories are encrypted using KMS                                                                                                                                                     | Cloudformation | [ECRRepositoryEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ECRRepositoryEncrypted.py)                                                                   |
|  134 | CKV_AWS_149 | resource | AWS::SecretsManager::Secret                                      | Ensure that Secrets Manager secret is encrypted using KMS CMK                                                                                                                                            | Cloudformation | [SecretManagerSecretEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SecretManagerSecretEncrypted.py)                                                       |
|  135 | CKV_AWS_154 | resource | AWS::Redshift::Cluster                                           | Ensure Redshift is not deployed outside of a VPC                                                                                                                                                         | Cloudformation | [RedshiftInEc2ClassicMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/RedshiftInEc2ClassicMode.py)                                                               |
|  136 | CKV_AWS_155 | resource | AWS::WorkSpaces::Workspace                                       | Ensure that Workspace user volumes are encrypted                                                                                                                                                         | Cloudformation | [WorkspaceUserVolumeEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/WorkspaceUserVolumeEncrypted.py)                                                       |
|  137 | CKV_AWS_156 | resource | AWS::WorkSpaces::Workspace                                       | Ensure that Workspace root volumes are encrypted                                                                                                                                                         | Cloudformation | [WorkspaceRootVolumeEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/WorkspaceRootVolumeEncrypted.py)                                                       |
|  138 | CKV_AWS_157 | resource | AWS::RDS::DBInstance                                             | Ensure that RDS instances have Multi-AZ enabled                                                                                                                                                          | Cloudformation | [RDSMultiAZEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/RDSMultiAZEnabled.py)                                                                             |
|  139 | CKV_AWS_158 | resource | AWS::Logs::LogGroup                                              | Ensure that CloudWatch Log Group is encrypted by KMS                                                                                                                                                     | Cloudformation | [CloudWatchLogGroupKMSKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/CloudWatchLogGroupKMSKey.py)                                                               |
|  140 | CKV_AWS_160 | resource | AWS::Timestream::Database                                        | Ensure that Timestream database is encrypted with KMS CMK                                                                                                                                                | Cloudformation | [TimestreamDatabaseKMSKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/TimestreamDatabaseKMSKey.py)                                                               |
|  141 | CKV_AWS_161 | resource | AWS::RDS::DBInstance                                             | Ensure RDS database has IAM authentication enabled                                                                                                                                                       | Cloudformation | [RDSIAMAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/RDSIAMAuthentication.py)                                                                       |
|  142 | CKV_AWS_162 | resource | AWS::RDS::DBCluster                                              | Ensure RDS cluster has IAM authentication enabled                                                                                                                                                        | Cloudformation | [RDSClusterIAMAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/RDSClusterIAMAuthentication.py)                                                         |
|  143 | CKV_AWS_163 | resource | AWS::ECR::Repository                                             | Ensure ECR image scanning on push is enabled                                                                                                                                                             | Cloudformation | [ECRImageScanning.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ECRImageScanning.py)                                                                               |
|  144 | CKV_AWS_164 | resource | AWS::Transfer::Server                                            | Ensure Transfer Server is not exposed publicly.                                                                                                                                                          | Cloudformation | [TransferServerIsPublic.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/TransferServerIsPublic.py)                                                                   |
|  145 | CKV_AWS_165 | resource | AWS::DynamoDB::GlobalTable                                       | Ensure DynamoDB global table point in time recovery (backup) is enabled                                                                                                                                  | Cloudformation | [DynamodbGlobalTableRecovery.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DynamodbGlobalTableRecovery.py)                                                         |
|  146 | CKV_AWS_166 | resource | AWS::Backup::BackupVault                                         | Ensure Backup Vault is encrypted at rest using KMS CMK                                                                                                                                                   | Cloudformation | [BackupVaultEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/BackupVaultEncrypted.py)                                                                       |
|  147 | CKV_AWS_170 | resource | AWS::QLDB::Ledger                                                | Ensure QLDB ledger permissions mode is set to STANDARD                                                                                                                                                   | Cloudformation | [QLDBLedgerPermissionsMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/QLDBLedgerPermissionsMode.py)                                                             |
|  148 | CKV_AWS_172 | resource | AWS::QLDB::Ledger                                                | Ensure QLDB ledger has deletion protection enabled                                                                                                                                                       | Cloudformation | [QLDBLedgerDeletionProtection.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/QLDBLedgerDeletionProtection.py)                                                       |
|  149 | CKV_AWS_173 | resource | AWS::Lambda::Function                                            | Check encryption settings for Lambda environment variable                                                                                                                                                | Cloudformation | [LambdaEnvironmentEncryptionSettings.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaEnvironmentEncryptionSettings.py)                                         |
|  150 | CKV_AWS_173 | resource | AWS::Serverless::Function                                        | Check encryption settings for Lambda environment variable                                                                                                                                                | Cloudformation | [LambdaEnvironmentEncryptionSettings.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaEnvironmentEncryptionSettings.py)                                         |
|  151 | CKV_AWS_174 | resource | AWS::CloudFront::Distribution                                    | Verify CloudFront Distribution Viewer Certificate is using TLS v1.2                                                                                                                                      | Cloudformation | [CloudFrontTLS12.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/CloudFrontTLS12.py)                                                                                 |
|  152 | CKV_AWS_187 | resource | AWS::SageMaker::Domain                                           | Ensure Sagemaker domain and notebook instance are encrypted by KMS using a customer managed Key (CMK)                                                                                                    | Cloudformation | [SagemakerNotebookEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SagemakerNotebookEncryptedWithCMK.py)                                             |
|  153 | CKV_AWS_187 | resource | AWS::SageMaker::NotebookInstance                                 | Ensure Sagemaker domain and notebook instance are encrypted by KMS using a customer managed Key (CMK)                                                                                                    | Cloudformation | [SagemakerNotebookEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SagemakerNotebookEncryptedWithCMK.py)                                             |
|  154 | CKV_AWS_192 | resource | AWS::WAFv2::WebACL                                               | Ensure WAF prevents message lookup in Log4j2. See CVE-2021-44228 aka log4jshell                                                                                                                          | Cloudformation | [WAFACLCVE202144228.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/WAFACLCVE202144228.py)                                                                           |
|  155 | CKV_AWS_193 | resource | AWS::AppSync::GraphQLApi                                         | Ensure AppSync has Logging enabled                                                                                                                                                                       | Cloudformation | [AppSyncLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/AppSyncLogging.py)                                                                                   |
|  156 | CKV_AWS_194 | resource | AWS::AppSync::GraphQLApi                                         | Ensure AppSync has Field-Level logs enabled                                                                                                                                                              | Cloudformation | [AppSyncFieldLevelLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/AppSyncFieldLevelLogs.py)                                                                     |
|  157 | CKV_AWS_195 | resource | AWS::Glue::Crawler                                               | Ensure Glue component has a security configuration associated                                                                                                                                            | Cloudformation | [GlueSecurityConfigurationEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/GlueSecurityConfigurationEnabled.py)                                               |
|  158 | CKV_AWS_195 | resource | AWS::Glue::DevEndpoint                                           | Ensure Glue component has a security configuration associated                                                                                                                                            | Cloudformation | [GlueSecurityConfigurationEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/GlueSecurityConfigurationEnabled.py)                                               |
|  159 | CKV_AWS_195 | resource | AWS::Glue::Job                                                   | Ensure Glue component has a security configuration associated                                                                                                                                            | Cloudformation | [GlueSecurityConfigurationEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/GlueSecurityConfigurationEnabled.py)                                               |
|  160 | CKV_AWS_197 | resource | AWS::AmazonMQ::Broker                                            | Ensure MQ Broker Audit logging is enabled                                                                                                                                                                | Cloudformation | [MQBrokerAuditLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/MQBrokerAuditLogging.py)                                                                       |
|  161 | CKV_AWS_258 | resource | AWS::Lambda::Url                                                 | Ensure that Lambda function URLs AuthType is not None                                                                                                                                                    | Cloudformation | [LambdaFunctionURLAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaFunctionURLAuth.py)                                                                     |
|  162 | CKV_AWS_260 | resource | AWS::EC2::SecurityGroup                                          | Ensure no security groups allow ingress from 0.0.0.0:0 to port 80                                                                                                                                        | Cloudformation | [SecurityGroupUnrestrictedIngress80.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SecurityGroupUnrestrictedIngress80.py)                                           |
|  163 | CKV_AWS_260 | resource | AWS::EC2::SecurityGroupIngress                                   | Ensure no security groups allow ingress from 0.0.0.0:0 to port 80                                                                                                                                        | Cloudformation | [SecurityGroupUnrestrictedIngress80.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SecurityGroupUnrestrictedIngress80.py)                                           |
|  164 | CKV_AWS_291 | resource | AWS::MSK::Cluster                                                | Ensure MSK nodes are private                                                                                                                                                                             | Cloudformation | [MSKClusterNodesArePrivate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/MSKClusterNodesArePrivate.py)                                                             |
|  165 | CKV_AWS_317 | resource | AWS::Elasticsearch::Domain                                       | Ensure Elasticsearch Domain Audit Logging is enabled                                                                                                                                                     | Cloudformation | [ElasticsearchDomainAuditLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ElasticsearchDomainAuditLogging.py)                                                 |
|  166 | CKV_AWS_317 | resource | AWS::OpenSearchService::Domain                                   | Ensure Elasticsearch Domain Audit Logging is enabled                                                                                                                                                     | Cloudformation | [ElasticsearchDomainAuditLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ElasticsearchDomainAuditLogging.py)                                                 |
|  167 | CKV_AWS_360 | resource | AWS::DocDB::DBCluster                                            | Ensure DocumentDB has an adequate backup retention period                                                                                                                                                | Cloudformation | [DocDBBackupRetention.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DocDBBackupRetention.py)                                                                       |
|  168 | CKV_AWS_361 | resource | AWS::Neptune::DBCluster                                          | Ensure that Neptune DB cluster has automated backups enabled with adequate retention                                                                                                                     | Cloudformation | [NeptuneClusterBackupRetention.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/NeptuneClusterBackupRetention.py)                                                     |
|  169 | CKV_AWS_363 | resource | AWS::Lambda::Function                                            | Ensure Lambda Runtime is not deprecated                                                                                                                                                                  | Cloudformation | [DeprecatedLambdaRuntime.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DeprecatedLambdaRuntime.py)                                                                 |
|  170 | CKV_AWS_363 | resource | AWS::Serverless::Function                                        | Ensure Lambda Runtime is not deprecated                                                                                                                                                                  | Cloudformation | [DeprecatedLambdaRuntime.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/DeprecatedLambdaRuntime.py)                                                                 |
|  171 | CKV_AWS_364 | resource | AWS::Lambda::Permission                                          | Ensure that AWS Lambda function permissions delegated to AWS services are limited by SourceArn or SourceAccount                                                                                          | Cloudformation | [LambdaServicePermission.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/LambdaServicePermission.py)                                                                 |
|  172 | CKV_AWS_366 | resource | AWS::Cognito::IdentityPool                                       | Ensure AWS Cognito identity pool does not allow unauthenticated guest access                                                                                                                             | Cloudformation | [CognitoUnauthenticatedIdentities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/CognitoUnauthenticatedIdentities.py)                                               |
|  173 | CKV_AWS_367 | resource | AWS::SageMaker::DataQualityJobDefinition                         | Ensure Amazon Sagemaker Data Quality Job uses KMS to encrypt model artifacts                                                                                                                             | Cloudformation | [SagemakerDataQualityJobDefinitionEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SagemakerDataQualityJobDefinitionEncryption.py)                         |
|  174 | CKV_AWS_368 | resource | AWS::SageMaker::DataQualityJobDefinition                         | Ensure Amazon Sagemaker Data Quality Job uses KMS to encrypt data on attached storage volume                                                                                                             | Cloudformation | [SagemakerDataQualityJobDefinitionVolumeEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SagemakerDataQualityJobDefinitionVolumeEncryption.py)             |
|  175 | CKV_AWS_369 | resource | AWS::SageMaker::DataQualityJobDefinition                         | Ensure Amazon Sagemaker Data Quality Job encrypts all communications between instances used for monitoring jobs                                                                                          | Cloudformation | [SagemakerDataQualityJobDefinitionTrafficEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SagemakerDataQualityJobDefinitionTrafficEncryption.py)           |
|  176 | CKV_AWS_370 | resource | AWS::SageMaker::Model                                            | Ensure Amazon SageMaker model uses network isolation                                                                                                                                                     | Cloudformation | [SagemakerModelWithNetworkIsolation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SagemakerModelWithNetworkIsolation.py)                                           |
|  177 | CKV_AWS_371 | resource | AWS::SageMaker::NotebookInstance                                 | Ensure Amazon SageMaker Notebook Instance only allows for IMDSv2                                                                                                                                         | Cloudformation | [SagemakerNotebookInstanceAllowsIMDSv2.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/SagemakerNotebookInstanceAllowsIMDSv2.py)                                     |
|  178 | CKV_AWS_373 | resource | AWS::Bedrock::Agent                                              | Ensure Bedrock Agent is encrypted with a CMK                                                                                                                                                             | Cloudformation | [BedrockAgentEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/BedrockAgentEncrypted.py)                                                                     |
|  179 | CKV_AWS_384 | resource | AWS::SSM::Parameter                                              | Ensure no hard-coded secrets exist in Parameter Store values                                                                                                                                             | Cloudformation | [ParameterStoreCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/resource/aws/ParameterStoreCredentials.py)                                                             |
|  180 | CKV2_AWS_33 | resource | AWS::AppSync::GraphQLApi                                         | Ensure AppSync is protected by WAF                                                                                                                                                                       | Cloudformation | [AppSyncProtectedByWAF.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/AppSyncProtectedByWAF.yaml)                                                                 |
|  181 | CKV2_AWS_68 | resource | AWS::IAM::Role                                                   | Ensure SageMaker notebook instance IAM policy is not overly permissive                                                                                                                                   | Cloudformation | [SageMakerIAMPolicyOverlyPermissiveToAllTraffic.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/SageMakerIAMPolicyOverlyPermissiveToAllTraffic.yaml)               |
|  182 | CKV2_AWS_68 | resource | AWS::SageMaker::NotebookInstance                                 | Ensure SageMaker notebook instance IAM policy is not overly permissive                                                                                                                                   | Cloudformation | [SageMakerIAMPolicyOverlyPermissiveToAllTraffic.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/SageMakerIAMPolicyOverlyPermissiveToAllTraffic.yaml)               |
|  183 | CKV2_AWS_69 | resource | AWS::RDS::DBInstance                                             | Ensure AWS RDS database instance configured with encryption in transit                                                                                                                                   | Cloudformation | [RDSEncryptionInTransit.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/RDSEncryptionInTransit.yaml)                                                               |
|  184 | CKV2_AWS_69 | resource | AWS::RDS::DBParameterGroup                                       | Ensure AWS RDS database instance configured with encryption in transit                                                                                                                                   | Cloudformation | [RDSEncryptionInTransit.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/RDSEncryptionInTransit.yaml)                                                               |
|  185 | CKV2_AWS_71 | resource | AWS::CertificateManager::Certificate                             | Ensure AWS ACM Certificate domain name does not include wildcards                                                                                                                                        | Cloudformation | [ACMWildcardDomainName.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/ACMWildcardDomainName.yaml)                                                                 |
|  186 | CKV2_AWS_72 | resource | AWS::CloudFront::Distribution                                    | Ensure AWS CloudFront origin protocol policy enforces HTTPS-only                                                                                                                                         | Cloudformation | [CloudfrontOriginNotHTTPSOnly.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/CloudfrontOriginNotHTTPSOnly.yaml)                                                   |
|  187 | CKV2_AWS_75 | resource | AWS::Lambda::Function                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  188 | CKV2_AWS_75 | resource | AWS::Lambda::Url                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  189 | CKV2_AWS_75 | resource | aws                                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  190 | CKV2_AWS_75 | resource | aws_accessanalyzer_analyzer                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  191 | CKV2_AWS_75 | resource | aws_accessanalyzer_archive_rule                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  192 | CKV2_AWS_75 | resource | aws_account_alternate_contact                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  193 | CKV2_AWS_75 | resource | aws_account_primary_contact                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  194 | CKV2_AWS_75 | resource | aws_account_region                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  195 | CKV2_AWS_75 | resource | aws_acm_certificate                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  196 | CKV2_AWS_75 | resource | aws_acm_certificate_validation                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  197 | CKV2_AWS_75 | resource | aws_acmpca_certificate                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  198 | CKV2_AWS_75 | resource | aws_acmpca_certificate_authority                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  199 | CKV2_AWS_75 | resource | aws_acmpca_certificate_authority_certificate                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  200 | CKV2_AWS_75 | resource | aws_acmpca_permission                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  201 | CKV2_AWS_75 | resource | aws_acmpca_policy                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  202 | CKV2_AWS_75 | resource | aws_alb                                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  203 | CKV2_AWS_75 | resource | aws_alb_listener                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  204 | CKV2_AWS_75 | resource | aws_alb_listener_certificate                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  205 | CKV2_AWS_75 | resource | aws_alb_listener_rule                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  206 | CKV2_AWS_75 | resource | aws_alb_target_group                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  207 | CKV2_AWS_75 | resource | aws_alb_target_group_attachment                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  208 | CKV2_AWS_75 | resource | aws_ami                                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  209 | CKV2_AWS_75 | resource | aws_ami_copy                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  210 | CKV2_AWS_75 | resource | aws_ami_from_instance                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  211 | CKV2_AWS_75 | resource | aws_ami_launch_permission                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  212 | CKV2_AWS_75 | resource | aws_amplify_app                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  213 | CKV2_AWS_75 | resource | aws_amplify_backend_environment                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  214 | CKV2_AWS_75 | resource | aws_amplify_branch                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  215 | CKV2_AWS_75 | resource | aws_amplify_domain_association                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  216 | CKV2_AWS_75 | resource | aws_amplify_webhook                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  217 | CKV2_AWS_75 | resource | aws_api_gateway_account                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  218 | CKV2_AWS_75 | resource | aws_api_gateway_api_key                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  219 | CKV2_AWS_75 | resource | aws_api_gateway_authorizer                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  220 | CKV2_AWS_75 | resource | aws_api_gateway_base_path_mapping                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  221 | CKV2_AWS_75 | resource | aws_api_gateway_client_certificate                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  222 | CKV2_AWS_75 | resource | aws_api_gateway_deployment                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  223 | CKV2_AWS_75 | resource | aws_api_gateway_documentation_part                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  224 | CKV2_AWS_75 | resource | aws_api_gateway_documentation_version                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  225 | CKV2_AWS_75 | resource | aws_api_gateway_domain_name                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  226 | CKV2_AWS_75 | resource | aws_api_gateway_domain_name_access_association                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  227 | CKV2_AWS_75 | resource | aws_api_gateway_gateway_response                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  228 | CKV2_AWS_75 | resource | aws_api_gateway_integration                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  229 | CKV2_AWS_75 | resource | aws_api_gateway_integration_response                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  230 | CKV2_AWS_75 | resource | aws_api_gateway_method                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  231 | CKV2_AWS_75 | resource | aws_api_gateway_method_response                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  232 | CKV2_AWS_75 | resource | aws_api_gateway_method_settings                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  233 | CKV2_AWS_75 | resource | aws_api_gateway_model                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  234 | CKV2_AWS_75 | resource | aws_api_gateway_request_validator                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  235 | CKV2_AWS_75 | resource | aws_api_gateway_resource                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  236 | CKV2_AWS_75 | resource | aws_api_gateway_rest_api                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  237 | CKV2_AWS_75 | resource | aws_api_gateway_rest_api_policy                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  238 | CKV2_AWS_75 | resource | aws_api_gateway_stage                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  239 | CKV2_AWS_75 | resource | aws_api_gateway_usage_plan                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  240 | CKV2_AWS_75 | resource | aws_api_gateway_usage_plan_key                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  241 | CKV2_AWS_75 | resource | aws_api_gateway_vpc_link                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  242 | CKV2_AWS_75 | resource | aws_apigatewayv2_api                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  243 | CKV2_AWS_75 | resource | aws_apigatewayv2_api_mapping                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  244 | CKV2_AWS_75 | resource | aws_apigatewayv2_authorizer                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  245 | CKV2_AWS_75 | resource | aws_apigatewayv2_deployment                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  246 | CKV2_AWS_75 | resource | aws_apigatewayv2_domain_name                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  247 | CKV2_AWS_75 | resource | aws_apigatewayv2_integration                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  248 | CKV2_AWS_75 | resource | aws_apigatewayv2_integration_response                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  249 | CKV2_AWS_75 | resource | aws_apigatewayv2_model                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  250 | CKV2_AWS_75 | resource | aws_apigatewayv2_route                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  251 | CKV2_AWS_75 | resource | aws_apigatewayv2_route_response                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  252 | CKV2_AWS_75 | resource | aws_apigatewayv2_stage                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  253 | CKV2_AWS_75 | resource | aws_apigatewayv2_vpc_link                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  254 | CKV2_AWS_75 | resource | aws_app_cookie_stickiness_policy                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  255 | CKV2_AWS_75 | resource | aws_appautoscaling_policy                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  256 | CKV2_AWS_75 | resource | aws_appautoscaling_scheduled_action                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  257 | CKV2_AWS_75 | resource | aws_appautoscaling_target                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  258 | CKV2_AWS_75 | resource | aws_appconfig_application                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  259 | CKV2_AWS_75 | resource | aws_appconfig_configuration_profile                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  260 | CKV2_AWS_75 | resource | aws_appconfig_deployment                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  261 | CKV2_AWS_75 | resource | aws_appconfig_deployment_strategy                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  262 | CKV2_AWS_75 | resource | aws_appconfig_environment                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  263 | CKV2_AWS_75 | resource | aws_appconfig_extension                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  264 | CKV2_AWS_75 | resource | aws_appconfig_extension_association                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  265 | CKV2_AWS_75 | resource | aws_appconfig_hosted_configuration_version                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  266 | CKV2_AWS_75 | resource | aws_appfabric_app_authorization                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  267 | CKV2_AWS_75 | resource | aws_appfabric_app_authorization_connection                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  268 | CKV2_AWS_75 | resource | aws_appfabric_app_bundle                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  269 | CKV2_AWS_75 | resource | aws_appfabric_ingestion                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  270 | CKV2_AWS_75 | resource | aws_appfabric_ingestion_destination                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  271 | CKV2_AWS_75 | resource | aws_appflow_connector_profile                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  272 | CKV2_AWS_75 | resource | aws_appflow_flow                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  273 | CKV2_AWS_75 | resource | aws_appintegrations_data_integration                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  274 | CKV2_AWS_75 | resource | aws_appintegrations_event_integration                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  275 | CKV2_AWS_75 | resource | aws_applicationinsights_application                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  276 | CKV2_AWS_75 | resource | aws_appmesh_gateway_route                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  277 | CKV2_AWS_75 | resource | aws_appmesh_mesh                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  278 | CKV2_AWS_75 | resource | aws_appmesh_route                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  279 | CKV2_AWS_75 | resource | aws_appmesh_virtual_gateway                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  280 | CKV2_AWS_75 | resource | aws_appmesh_virtual_node                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  281 | CKV2_AWS_75 | resource | aws_appmesh_virtual_router                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  282 | CKV2_AWS_75 | resource | aws_appmesh_virtual_service                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  283 | CKV2_AWS_75 | resource | aws_apprunner_auto_scaling_configuration_version                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  284 | CKV2_AWS_75 | resource | aws_apprunner_connection                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  285 | CKV2_AWS_75 | resource | aws_apprunner_custom_domain_association                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  286 | CKV2_AWS_75 | resource | aws_apprunner_default_auto_scaling_configuration_version         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  287 | CKV2_AWS_75 | resource | aws_apprunner_deployment                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  288 | CKV2_AWS_75 | resource | aws_apprunner_observability_configuration                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  289 | CKV2_AWS_75 | resource | aws_apprunner_service                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  290 | CKV2_AWS_75 | resource | aws_apprunner_vpc_connector                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  291 | CKV2_AWS_75 | resource | aws_apprunner_vpc_ingress_connection                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  292 | CKV2_AWS_75 | resource | aws_appstream_directory_config                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  293 | CKV2_AWS_75 | resource | aws_appstream_fleet                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  294 | CKV2_AWS_75 | resource | aws_appstream_fleet_stack_association                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  295 | CKV2_AWS_75 | resource | aws_appstream_image_builder                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  296 | CKV2_AWS_75 | resource | aws_appstream_stack                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  297 | CKV2_AWS_75 | resource | aws_appstream_user                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  298 | CKV2_AWS_75 | resource | aws_appstream_user_stack_association                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  299 | CKV2_AWS_75 | resource | aws_appsync_api_cache                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  300 | CKV2_AWS_75 | resource | aws_appsync_api_key                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  301 | CKV2_AWS_75 | resource | aws_appsync_datasource                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  302 | CKV2_AWS_75 | resource | aws_appsync_domain_name                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  303 | CKV2_AWS_75 | resource | aws_appsync_domain_name_api_association                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  304 | CKV2_AWS_75 | resource | aws_appsync_function                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  305 | CKV2_AWS_75 | resource | aws_appsync_graphql_api                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  306 | CKV2_AWS_75 | resource | aws_appsync_resolver                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  307 | CKV2_AWS_75 | resource | aws_appsync_source_api_association                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  308 | CKV2_AWS_75 | resource | aws_appsync_type                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  309 | CKV2_AWS_75 | resource | aws_athena_data_catalog                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  310 | CKV2_AWS_75 | resource | aws_athena_database                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  311 | CKV2_AWS_75 | resource | aws_athena_named_query                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  312 | CKV2_AWS_75 | resource | aws_athena_prepared_statement                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  313 | CKV2_AWS_75 | resource | aws_athena_workgroup                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  314 | CKV2_AWS_75 | resource | aws_auditmanager_account_registration                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  315 | CKV2_AWS_75 | resource | aws_auditmanager_assessment                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  316 | CKV2_AWS_75 | resource | aws_auditmanager_assessment_delegation                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  317 | CKV2_AWS_75 | resource | aws_auditmanager_assessment_report                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  318 | CKV2_AWS_75 | resource | aws_auditmanager_control                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  319 | CKV2_AWS_75 | resource | aws_auditmanager_framework                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  320 | CKV2_AWS_75 | resource | aws_auditmanager_framework_share                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  321 | CKV2_AWS_75 | resource | aws_auditmanager_organization_admin_account_registration         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  322 | CKV2_AWS_75 | resource | aws_autoscaling_attachment                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  323 | CKV2_AWS_75 | resource | aws_autoscaling_group                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  324 | CKV2_AWS_75 | resource | aws_autoscaling_group_tag                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  325 | CKV2_AWS_75 | resource | aws_autoscaling_lifecycle_hook                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  326 | CKV2_AWS_75 | resource | aws_autoscaling_notification                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  327 | CKV2_AWS_75 | resource | aws_autoscaling_policy                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  328 | CKV2_AWS_75 | resource | aws_autoscaling_schedule                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  329 | CKV2_AWS_75 | resource | aws_autoscaling_traffic_source_attachment                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  330 | CKV2_AWS_75 | resource | aws_autoscalingplans_scaling_plan                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  331 | CKV2_AWS_75 | resource | aws_az_info                                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  332 | CKV2_AWS_75 | resource | aws_backup_framework                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  333 | CKV2_AWS_75 | resource | aws_backup_global_settings                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  334 | CKV2_AWS_75 | resource | aws_backup_logically_air_gapped_vault                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  335 | CKV2_AWS_75 | resource | aws_backup_plan                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  336 | CKV2_AWS_75 | resource | aws_backup_region_settings                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  337 | CKV2_AWS_75 | resource | aws_backup_report_plan                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  338 | CKV2_AWS_75 | resource | aws_backup_restore_testing_plan                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  339 | CKV2_AWS_75 | resource | aws_backup_restore_testing_selection                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  340 | CKV2_AWS_75 | resource | aws_backup_selection                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  341 | CKV2_AWS_75 | resource | aws_backup_vault                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  342 | CKV2_AWS_75 | resource | aws_backup_vault_lock_configuration                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  343 | CKV2_AWS_75 | resource | aws_backup_vault_notifications                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  344 | CKV2_AWS_75 | resource | aws_backup_vault_policy                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  345 | CKV2_AWS_75 | resource | aws_batch_compute_environment                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  346 | CKV2_AWS_75 | resource | aws_batch_job_definition                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  347 | CKV2_AWS_75 | resource | aws_batch_job_queue                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  348 | CKV2_AWS_75 | resource | aws_batch_scheduling_policy                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  349 | CKV2_AWS_75 | resource | aws_bcmdataexports_export                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  350 | CKV2_AWS_75 | resource | aws_bedrock_custom_model                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  351 | CKV2_AWS_75 | resource | aws_bedrock_guardrail                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  352 | CKV2_AWS_75 | resource | aws_bedrock_guardrail_version                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  353 | CKV2_AWS_75 | resource | aws_bedrock_inference_profile                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  354 | CKV2_AWS_75 | resource | aws_bedrock_model_invocation_logging_configuration               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  355 | CKV2_AWS_75 | resource | aws_bedrock_provisioned_model_throughput                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  356 | CKV2_AWS_75 | resource | aws_bedrockagent_agent                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  357 | CKV2_AWS_75 | resource | aws_bedrockagent_agent_action_group                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  358 | CKV2_AWS_75 | resource | aws_bedrockagent_agent_alias                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  359 | CKV2_AWS_75 | resource | aws_bedrockagent_agent_collaborator                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  360 | CKV2_AWS_75 | resource | aws_bedrockagent_agent_knowledge_base_association                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  361 | CKV2_AWS_75 | resource | aws_bedrockagent_data_source                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  362 | CKV2_AWS_75 | resource | aws_bedrockagent_knowledge_base                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  363 | CKV2_AWS_75 | resource | aws_budgets_budget                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  364 | CKV2_AWS_75 | resource | aws_budgets_budget_action                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  365 | CKV2_AWS_75 | resource | aws_caller_info                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  366 | CKV2_AWS_75 | resource | aws_ce_anomaly_monitor                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  367 | CKV2_AWS_75 | resource | aws_ce_anomaly_subscription                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  368 | CKV2_AWS_75 | resource | aws_ce_cost_allocation_tag                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  369 | CKV2_AWS_75 | resource | aws_ce_cost_category                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  370 | CKV2_AWS_75 | resource | aws_chatbot_slack_channel_configuration                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  371 | CKV2_AWS_75 | resource | aws_chatbot_teams_channel_configuration                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  372 | CKV2_AWS_75 | resource | aws_chime_voice_connector                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  373 | CKV2_AWS_75 | resource | aws_chime_voice_connector_group                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  374 | CKV2_AWS_75 | resource | aws_chime_voice_connector_logging                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  375 | CKV2_AWS_75 | resource | aws_chime_voice_connector_origination                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  376 | CKV2_AWS_75 | resource | aws_chime_voice_connector_streaming                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  377 | CKV2_AWS_75 | resource | aws_chime_voice_connector_termination                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  378 | CKV2_AWS_75 | resource | aws_chime_voice_connector_termination_credentials                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  379 | CKV2_AWS_75 | resource | aws_chimesdkmediapipelines_media_insights_pipeline_configuration | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  380 | CKV2_AWS_75 | resource | aws_chimesdkvoice_global_settings                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  381 | CKV2_AWS_75 | resource | aws_chimesdkvoice_sip_media_application                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  382 | CKV2_AWS_75 | resource | aws_chimesdkvoice_sip_rule                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  383 | CKV2_AWS_75 | resource | aws_chimesdkvoice_voice_profile_domain                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  384 | CKV2_AWS_75 | resource | aws_cleanrooms_collaboration                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  385 | CKV2_AWS_75 | resource | aws_cleanrooms_configured_table                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  386 | CKV2_AWS_75 | resource | aws_cleanrooms_membership                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  387 | CKV2_AWS_75 | resource | aws_cloud9_environment_ec2                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  388 | CKV2_AWS_75 | resource | aws_cloud9_environment_membership                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  389 | CKV2_AWS_75 | resource | aws_cloudcontrolapi_resource                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  390 | CKV2_AWS_75 | resource | aws_cloudformation_stack                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  391 | CKV2_AWS_75 | resource | aws_cloudformation_stack_instances                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  392 | CKV2_AWS_75 | resource | aws_cloudformation_stack_set                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  393 | CKV2_AWS_75 | resource | aws_cloudformation_stack_set_instance                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  394 | CKV2_AWS_75 | resource | aws_cloudformation_type                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  395 | CKV2_AWS_75 | resource | aws_cloudfront_cache_policy                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  396 | CKV2_AWS_75 | resource | aws_cloudfront_continuous_deployment_policy                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  397 | CKV2_AWS_75 | resource | aws_cloudfront_distribution                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  398 | CKV2_AWS_75 | resource | aws_cloudfront_field_level_encryption_config                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  399 | CKV2_AWS_75 | resource | aws_cloudfront_field_level_encryption_profile                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  400 | CKV2_AWS_75 | resource | aws_cloudfront_function                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  401 | CKV2_AWS_75 | resource | aws_cloudfront_key_group                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  402 | CKV2_AWS_75 | resource | aws_cloudfront_key_value_store                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  403 | CKV2_AWS_75 | resource | aws_cloudfront_monitoring_subscription                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  404 | CKV2_AWS_75 | resource | aws_cloudfront_origin_access_control                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  405 | CKV2_AWS_75 | resource | aws_cloudfront_origin_access_identity                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  406 | CKV2_AWS_75 | resource | aws_cloudfront_origin_request_policy                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  407 | CKV2_AWS_75 | resource | aws_cloudfront_public_key                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  408 | CKV2_AWS_75 | resource | aws_cloudfront_realtime_log_config                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  409 | CKV2_AWS_75 | resource | aws_cloudfront_response_headers_policy                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  410 | CKV2_AWS_75 | resource | aws_cloudfront_vpc_origin                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  411 | CKV2_AWS_75 | resource | aws_cloudfrontkeyvaluestore_key                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  412 | CKV2_AWS_75 | resource | aws_cloudhsm_v2_cluster                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  413 | CKV2_AWS_75 | resource | aws_cloudhsm_v2_hsm                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  414 | CKV2_AWS_75 | resource | aws_cloudsearch_domain                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  415 | CKV2_AWS_75 | resource | aws_cloudsearch_domain_service_access_policy                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  416 | CKV2_AWS_75 | resource | aws_cloudtrail                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  417 | CKV2_AWS_75 | resource | aws_cloudtrail_event_data_store                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  418 | CKV2_AWS_75 | resource | aws_cloudtrail_organization_delegated_admin_account              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  419 | CKV2_AWS_75 | resource | aws_cloudwatch_composite_alarm                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  420 | CKV2_AWS_75 | resource | aws_cloudwatch_dashboard                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  421 | CKV2_AWS_75 | resource | aws_cloudwatch_event_api_destination                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  422 | CKV2_AWS_75 | resource | aws_cloudwatch_event_archive                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  423 | CKV2_AWS_75 | resource | aws_cloudwatch_event_bus                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  424 | CKV2_AWS_75 | resource | aws_cloudwatch_event_bus_policy                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  425 | CKV2_AWS_75 | resource | aws_cloudwatch_event_connection                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  426 | CKV2_AWS_75 | resource | aws_cloudwatch_event_endpoint                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  427 | CKV2_AWS_75 | resource | aws_cloudwatch_event_permission                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  428 | CKV2_AWS_75 | resource | aws_cloudwatch_event_rule                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  429 | CKV2_AWS_75 | resource | aws_cloudwatch_event_target                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  430 | CKV2_AWS_75 | resource | aws_cloudwatch_log_account_policy                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  431 | CKV2_AWS_75 | resource | aws_cloudwatch_log_anomaly_detector                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  432 | CKV2_AWS_75 | resource | aws_cloudwatch_log_data_protection_policy                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  433 | CKV2_AWS_75 | resource | aws_cloudwatch_log_delivery                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  434 | CKV2_AWS_75 | resource | aws_cloudwatch_log_delivery_destination                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  435 | CKV2_AWS_75 | resource | aws_cloudwatch_log_delivery_destination_policy                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  436 | CKV2_AWS_75 | resource | aws_cloudwatch_log_delivery_source                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  437 | CKV2_AWS_75 | resource | aws_cloudwatch_log_destination                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  438 | CKV2_AWS_75 | resource | aws_cloudwatch_log_destination_policy                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  439 | CKV2_AWS_75 | resource | aws_cloudwatch_log_group                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  440 | CKV2_AWS_75 | resource | aws_cloudwatch_log_index_policy                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  441 | CKV2_AWS_75 | resource | aws_cloudwatch_log_metric_filter                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  442 | CKV2_AWS_75 | resource | aws_cloudwatch_log_resource_policy                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  443 | CKV2_AWS_75 | resource | aws_cloudwatch_log_stream                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  444 | CKV2_AWS_75 | resource | aws_cloudwatch_log_subscription_filter                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  445 | CKV2_AWS_75 | resource | aws_cloudwatch_metric_alarm                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  446 | CKV2_AWS_75 | resource | aws_cloudwatch_metric_stream                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  447 | CKV2_AWS_75 | resource | aws_cloudwatch_query_definition                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  448 | CKV2_AWS_75 | resource | aws_codeartifact_domain                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  449 | CKV2_AWS_75 | resource | aws_codeartifact_domain_permissions_policy                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  450 | CKV2_AWS_75 | resource | aws_codeartifact_repository                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  451 | CKV2_AWS_75 | resource | aws_codeartifact_repository_permissions_policy                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  452 | CKV2_AWS_75 | resource | aws_codebuild_fleet                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  453 | CKV2_AWS_75 | resource | aws_codebuild_project                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  454 | CKV2_AWS_75 | resource | aws_codebuild_report_group                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  455 | CKV2_AWS_75 | resource | aws_codebuild_resource_policy                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  456 | CKV2_AWS_75 | resource | aws_codebuild_source_credential                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  457 | CKV2_AWS_75 | resource | aws_codebuild_webhook                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  458 | CKV2_AWS_75 | resource | aws_codecatalyst_dev_environment                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  459 | CKV2_AWS_75 | resource | aws_codecatalyst_project                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  460 | CKV2_AWS_75 | resource | aws_codecatalyst_source_repository                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  461 | CKV2_AWS_75 | resource | aws_codecommit_approval_rule_template                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  462 | CKV2_AWS_75 | resource | aws_codecommit_approval_rule_template_association                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  463 | CKV2_AWS_75 | resource | aws_codecommit_repository                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  464 | CKV2_AWS_75 | resource | aws_codecommit_trigger                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  465 | CKV2_AWS_75 | resource | aws_codeconnections_connection                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  466 | CKV2_AWS_75 | resource | aws_codeconnections_host                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  467 | CKV2_AWS_75 | resource | aws_codedeploy_app                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  468 | CKV2_AWS_75 | resource | aws_codedeploy_deployment_config                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  469 | CKV2_AWS_75 | resource | aws_codedeploy_deployment_group                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  470 | CKV2_AWS_75 | resource | aws_codeguruprofiler_profiling_group                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  471 | CKV2_AWS_75 | resource | aws_codegurureviewer_repository_association                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  472 | CKV2_AWS_75 | resource | aws_codepipeline                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  473 | CKV2_AWS_75 | resource | aws_codepipeline_custom_action_type                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  474 | CKV2_AWS_75 | resource | aws_codepipeline_webhook                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  475 | CKV2_AWS_75 | resource | aws_codestarconnections_connection                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  476 | CKV2_AWS_75 | resource | aws_codestarconnections_host                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  477 | CKV2_AWS_75 | resource | aws_codestarnotifications_notification_rule                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  478 | CKV2_AWS_75 | resource | aws_cognito_identity_pool                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  479 | CKV2_AWS_75 | resource | aws_cognito_identity_pool_provider_principal_tag                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  480 | CKV2_AWS_75 | resource | aws_cognito_identity_pool_roles_attachment                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  481 | CKV2_AWS_75 | resource | aws_cognito_identity_provider                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  482 | CKV2_AWS_75 | resource | aws_cognito_managed_user_pool_client                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  483 | CKV2_AWS_75 | resource | aws_cognito_resource_server                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  484 | CKV2_AWS_75 | resource | aws_cognito_risk_configuration                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  485 | CKV2_AWS_75 | resource | aws_cognito_user                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  486 | CKV2_AWS_75 | resource | aws_cognito_user_group                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  487 | CKV2_AWS_75 | resource | aws_cognito_user_in_group                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  488 | CKV2_AWS_75 | resource | aws_cognito_user_pool                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  489 | CKV2_AWS_75 | resource | aws_cognito_user_pool_client                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  490 | CKV2_AWS_75 | resource | aws_cognito_user_pool_domain                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  491 | CKV2_AWS_75 | resource | aws_cognito_user_pool_ui_customization                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  492 | CKV2_AWS_75 | resource | aws_comprehend_document_classifier                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  493 | CKV2_AWS_75 | resource | aws_comprehend_entity_recognizer                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  494 | CKV2_AWS_75 | resource | aws_computeoptimizer_enrollment_status                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  495 | CKV2_AWS_75 | resource | aws_computeoptimizer_recommendation_preferences                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  496 | CKV2_AWS_75 | resource | aws_config_aggregate_authorization                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  497 | CKV2_AWS_75 | resource | aws_config_config_rule                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  498 | CKV2_AWS_75 | resource | aws_config_configuration_aggregator                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  499 | CKV2_AWS_75 | resource | aws_config_configuration_recorder                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  500 | CKV2_AWS_75 | resource | aws_config_configuration_recorder_status                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  501 | CKV2_AWS_75 | resource | aws_config_conformance_pack                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  502 | CKV2_AWS_75 | resource | aws_config_delivery_channel                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  503 | CKV2_AWS_75 | resource | aws_config_organization_conformance_pack                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  504 | CKV2_AWS_75 | resource | aws_config_organization_custom_policy_rule                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  505 | CKV2_AWS_75 | resource | aws_config_organization_custom_rule                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  506 | CKV2_AWS_75 | resource | aws_config_organization_managed_rule                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  507 | CKV2_AWS_75 | resource | aws_config_remediation_configuration                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  508 | CKV2_AWS_75 | resource | aws_config_retention_configuration                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  509 | CKV2_AWS_75 | resource | aws_connect_bot_association                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  510 | CKV2_AWS_75 | resource | aws_connect_contact_flow                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  511 | CKV2_AWS_75 | resource | aws_connect_contact_flow_module                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  512 | CKV2_AWS_75 | resource | aws_connect_hours_of_operation                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  513 | CKV2_AWS_75 | resource | aws_connect_instance                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  514 | CKV2_AWS_75 | resource | aws_connect_instance_storage_config                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  515 | CKV2_AWS_75 | resource | aws_connect_lambda_function_association                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  516 | CKV2_AWS_75 | resource | aws_connect_phone_number                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  517 | CKV2_AWS_75 | resource | aws_connect_queue                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  518 | CKV2_AWS_75 | resource | aws_connect_quick_connect                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  519 | CKV2_AWS_75 | resource | aws_connect_routing_profile                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  520 | CKV2_AWS_75 | resource | aws_connect_security_profile                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  521 | CKV2_AWS_75 | resource | aws_connect_user                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  522 | CKV2_AWS_75 | resource | aws_connect_user_hierarchy_group                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  523 | CKV2_AWS_75 | resource | aws_connect_user_hierarchy_structure                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  524 | CKV2_AWS_75 | resource | aws_connect_vocabulary                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  525 | CKV2_AWS_75 | resource | aws_controltower_control                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  526 | CKV2_AWS_75 | resource | aws_controltower_landing_zone                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  527 | CKV2_AWS_75 | resource | aws_costoptimizationhub_enrollment_status                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  528 | CKV2_AWS_75 | resource | aws_costoptimizationhub_preferences                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  529 | CKV2_AWS_75 | resource | aws_cur_report_definition                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  530 | CKV2_AWS_75 | resource | aws_customer_gateway                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  531 | CKV2_AWS_75 | resource | aws_customerprofiles_domain                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  532 | CKV2_AWS_75 | resource | aws_customerprofiles_profile                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  533 | CKV2_AWS_75 | resource | aws_dataexchange_data_set                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  534 | CKV2_AWS_75 | resource | aws_dataexchange_revision                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  535 | CKV2_AWS_75 | resource | aws_datapipeline_pipeline                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  536 | CKV2_AWS_75 | resource | aws_datapipeline_pipeline_definition                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  537 | CKV2_AWS_75 | resource | aws_datasync_agent                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  538 | CKV2_AWS_75 | resource | aws_datasync_location_azure_blob                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  539 | CKV2_AWS_75 | resource | aws_datasync_location_efs                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  540 | CKV2_AWS_75 | resource | aws_datasync_location_fsx_lustre_file_system                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  541 | CKV2_AWS_75 | resource | aws_datasync_location_fsx_ontap_file_system                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  542 | CKV2_AWS_75 | resource | aws_datasync_location_fsx_openzfs_file_system                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  543 | CKV2_AWS_75 | resource | aws_datasync_location_fsx_windows_file_system                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  544 | CKV2_AWS_75 | resource | aws_datasync_location_hdfs                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  545 | CKV2_AWS_75 | resource | aws_datasync_location_nfs                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  546 | CKV2_AWS_75 | resource | aws_datasync_location_object_storage                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  547 | CKV2_AWS_75 | resource | aws_datasync_location_s3                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  548 | CKV2_AWS_75 | resource | aws_datasync_location_smb                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  549 | CKV2_AWS_75 | resource | aws_datasync_task                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  550 | CKV2_AWS_75 | resource | aws_datazone_asset_type                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  551 | CKV2_AWS_75 | resource | aws_datazone_domain                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  552 | CKV2_AWS_75 | resource | aws_datazone_environment                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  553 | CKV2_AWS_75 | resource | aws_datazone_environment_blueprint_configuration                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  554 | CKV2_AWS_75 | resource | aws_datazone_environment_profile                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  555 | CKV2_AWS_75 | resource | aws_datazone_form_type                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  556 | CKV2_AWS_75 | resource | aws_datazone_glossary                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  557 | CKV2_AWS_75 | resource | aws_datazone_glossary_term                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  558 | CKV2_AWS_75 | resource | aws_datazone_project                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  559 | CKV2_AWS_75 | resource | aws_datazone_user_profile                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  560 | CKV2_AWS_75 | resource | aws_dax_cluster                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  561 | CKV2_AWS_75 | resource | aws_dax_parameter_group                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  562 | CKV2_AWS_75 | resource | aws_dax_subnet_group                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  563 | CKV2_AWS_75 | resource | aws_db_cluster_snapshot                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  564 | CKV2_AWS_75 | resource | aws_db_event_subscription                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  565 | CKV2_AWS_75 | resource | aws_db_instance                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  566 | CKV2_AWS_75 | resource | aws_db_instance_automated_backups_replication                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  567 | CKV2_AWS_75 | resource | aws_db_instance_role_association                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  568 | CKV2_AWS_75 | resource | aws_db_option_group                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  569 | CKV2_AWS_75 | resource | aws_db_parameter_group                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  570 | CKV2_AWS_75 | resource | aws_db_proxy                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  571 | CKV2_AWS_75 | resource | aws_db_proxy_default_target_group                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  572 | CKV2_AWS_75 | resource | aws_db_proxy_endpoint                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  573 | CKV2_AWS_75 | resource | aws_db_proxy_target                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  574 | CKV2_AWS_75 | resource | aws_db_security_group                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  575 | CKV2_AWS_75 | resource | aws_db_snapshot                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  576 | CKV2_AWS_75 | resource | aws_db_snapshot_copy                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  577 | CKV2_AWS_75 | resource | aws_db_subnet_group                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  578 | CKV2_AWS_75 | resource | aws_default_network_acl                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  579 | CKV2_AWS_75 | resource | aws_default_route_table                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  580 | CKV2_AWS_75 | resource | aws_default_security_group                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  581 | CKV2_AWS_75 | resource | aws_default_subnet                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  582 | CKV2_AWS_75 | resource | aws_default_vpc                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  583 | CKV2_AWS_75 | resource | aws_default_vpc_dhcp_options                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  584 | CKV2_AWS_75 | resource | aws_detective_graph                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  585 | CKV2_AWS_75 | resource | aws_detective_invitation_accepter                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  586 | CKV2_AWS_75 | resource | aws_detective_member                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  587 | CKV2_AWS_75 | resource | aws_detective_organization_admin_account                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  588 | CKV2_AWS_75 | resource | aws_detective_organization_configuration                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  589 | CKV2_AWS_75 | resource | aws_devicefarm_device_pool                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  590 | CKV2_AWS_75 | resource | aws_devicefarm_instance_profile                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  591 | CKV2_AWS_75 | resource | aws_devicefarm_network_profile                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  592 | CKV2_AWS_75 | resource | aws_devicefarm_project                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  593 | CKV2_AWS_75 | resource | aws_devicefarm_test_grid_project                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  594 | CKV2_AWS_75 | resource | aws_devicefarm_upload                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  595 | CKV2_AWS_75 | resource | aws_devopsguru_event_sources_config                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  596 | CKV2_AWS_75 | resource | aws_devopsguru_notification_channel                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  597 | CKV2_AWS_75 | resource | aws_devopsguru_resource_collection                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  598 | CKV2_AWS_75 | resource | aws_devopsguru_service_integration                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  599 | CKV2_AWS_75 | resource | aws_directory_service_conditional_forwarder                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  600 | CKV2_AWS_75 | resource | aws_directory_service_directory                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  601 | CKV2_AWS_75 | resource | aws_directory_service_log_subscription                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  602 | CKV2_AWS_75 | resource | aws_directory_service_radius_settings                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  603 | CKV2_AWS_75 | resource | aws_directory_service_region                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  604 | CKV2_AWS_75 | resource | aws_directory_service_shared_directory                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  605 | CKV2_AWS_75 | resource | aws_directory_service_shared_directory_accepter                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  606 | CKV2_AWS_75 | resource | aws_directory_service_trust                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  607 | CKV2_AWS_75 | resource | aws_dlm_lifecycle_policy                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  608 | CKV2_AWS_75 | resource | aws_dms_certificate                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  609 | CKV2_AWS_75 | resource | aws_dms_endpoint                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  610 | CKV2_AWS_75 | resource | aws_dms_event_subscription                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  611 | CKV2_AWS_75 | resource | aws_dms_replication_config                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  612 | CKV2_AWS_75 | resource | aws_dms_replication_instance                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  613 | CKV2_AWS_75 | resource | aws_dms_replication_subnet_group                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  614 | CKV2_AWS_75 | resource | aws_dms_replication_task                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  615 | CKV2_AWS_75 | resource | aws_dms_s3_endpoint                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  616 | CKV2_AWS_75 | resource | aws_docdb_cluster                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  617 | CKV2_AWS_75 | resource | aws_docdb_cluster_instance                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  618 | CKV2_AWS_75 | resource | aws_docdb_cluster_parameter_group                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  619 | CKV2_AWS_75 | resource | aws_docdb_cluster_snapshot                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  620 | CKV2_AWS_75 | resource | aws_docdb_event_subscription                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  621 | CKV2_AWS_75 | resource | aws_docdb_global_cluster                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  622 | CKV2_AWS_75 | resource | aws_docdb_subnet_group                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  623 | CKV2_AWS_75 | resource | aws_docdbelastic_cluster                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  624 | CKV2_AWS_75 | resource | aws_drs_replication_configuration_template                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  625 | CKV2_AWS_75 | resource | aws_dx_bgp_peer                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  626 | CKV2_AWS_75 | resource | aws_dx_connection                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  627 | CKV2_AWS_75 | resource | aws_dx_connection_association                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  628 | CKV2_AWS_75 | resource | aws_dx_connection_confirmation                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  629 | CKV2_AWS_75 | resource | aws_dx_gateway                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  630 | CKV2_AWS_75 | resource | aws_dx_gateway_association                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  631 | CKV2_AWS_75 | resource | aws_dx_gateway_association_proposal                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  632 | CKV2_AWS_75 | resource | aws_dx_hosted_connection                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  633 | CKV2_AWS_75 | resource | aws_dx_hosted_private_virtual_interface                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  634 | CKV2_AWS_75 | resource | aws_dx_hosted_private_virtual_interface_accepter                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  635 | CKV2_AWS_75 | resource | aws_dx_hosted_public_virtual_interface                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  636 | CKV2_AWS_75 | resource | aws_dx_hosted_public_virtual_interface_accepter                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  637 | CKV2_AWS_75 | resource | aws_dx_hosted_transit_virtual_interface                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  638 | CKV2_AWS_75 | resource | aws_dx_hosted_transit_virtual_interface_accepter                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  639 | CKV2_AWS_75 | resource | aws_dx_lag                                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  640 | CKV2_AWS_75 | resource | aws_dx_macsec_key_association                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  641 | CKV2_AWS_75 | resource | aws_dx_private_virtual_interface                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  642 | CKV2_AWS_75 | resource | aws_dx_public_virtual_interface                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  643 | CKV2_AWS_75 | resource | aws_dx_transit_virtual_interface                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  644 | CKV2_AWS_75 | resource | aws_dynamodb_contributor_insights                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  645 | CKV2_AWS_75 | resource | aws_dynamodb_global_table                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  646 | CKV2_AWS_75 | resource | aws_dynamodb_kinesis_streaming_destination                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  647 | CKV2_AWS_75 | resource | aws_dynamodb_resource_policy                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  648 | CKV2_AWS_75 | resource | aws_dynamodb_table                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  649 | CKV2_AWS_75 | resource | aws_dynamodb_table_export                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  650 | CKV2_AWS_75 | resource | aws_dynamodb_table_item                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  651 | CKV2_AWS_75 | resource | aws_dynamodb_table_replica                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  652 | CKV2_AWS_75 | resource | aws_dynamodb_tag                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  653 | CKV2_AWS_75 | resource | aws_ebs_default_kms_key                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  654 | CKV2_AWS_75 | resource | aws_ebs_encryption_by_default                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  655 | CKV2_AWS_75 | resource | aws_ebs_fast_snapshot_restore                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  656 | CKV2_AWS_75 | resource | aws_ebs_snapshot                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  657 | CKV2_AWS_75 | resource | aws_ebs_snapshot_block_public_access                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  658 | CKV2_AWS_75 | resource | aws_ebs_snapshot_copy                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  659 | CKV2_AWS_75 | resource | aws_ebs_snapshot_import                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  660 | CKV2_AWS_75 | resource | aws_ebs_volume                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  661 | CKV2_AWS_75 | resource | aws_ec2_availability_zone_group                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  662 | CKV2_AWS_75 | resource | aws_ec2_capacity_block_reservation                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  663 | CKV2_AWS_75 | resource | aws_ec2_capacity_reservation                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  664 | CKV2_AWS_75 | resource | aws_ec2_carrier_gateway                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  665 | CKV2_AWS_75 | resource | aws_ec2_client_vpn_authorization_rule                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  666 | CKV2_AWS_75 | resource | aws_ec2_client_vpn_endpoint                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  667 | CKV2_AWS_75 | resource | aws_ec2_client_vpn_network_association                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  668 | CKV2_AWS_75 | resource | aws_ec2_client_vpn_route                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  669 | CKV2_AWS_75 | resource | aws_ec2_fleet                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  670 | CKV2_AWS_75 | resource | aws_ec2_host                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  671 | CKV2_AWS_75 | resource | aws_ec2_image_block_public_access                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  672 | CKV2_AWS_75 | resource | aws_ec2_instance_connect_endpoint                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  673 | CKV2_AWS_75 | resource | aws_ec2_instance_metadata_defaults                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  674 | CKV2_AWS_75 | resource | aws_ec2_instance_state                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  675 | CKV2_AWS_75 | resource | aws_ec2_local_gateway_route                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  676 | CKV2_AWS_75 | resource | aws_ec2_local_gateway_route_table_vpc_association                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  677 | CKV2_AWS_75 | resource | aws_ec2_managed_prefix_list                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  678 | CKV2_AWS_75 | resource | aws_ec2_managed_prefix_list_entry                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  679 | CKV2_AWS_75 | resource | aws_ec2_network_insights_analysis                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  680 | CKV2_AWS_75 | resource | aws_ec2_network_insights_path                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  681 | CKV2_AWS_75 | resource | aws_ec2_serial_console_access                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  682 | CKV2_AWS_75 | resource | aws_ec2_subnet_cidr_reservation                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  683 | CKV2_AWS_75 | resource | aws_ec2_tag                                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  684 | CKV2_AWS_75 | resource | aws_ec2_traffic_mirror_filter                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  685 | CKV2_AWS_75 | resource | aws_ec2_traffic_mirror_filter_rule                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  686 | CKV2_AWS_75 | resource | aws_ec2_traffic_mirror_session                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  687 | CKV2_AWS_75 | resource | aws_ec2_traffic_mirror_target                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  688 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  689 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_connect                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  690 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_connect_peer                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  691 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_default_route_table_association          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  692 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_default_route_table_propagation          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  693 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_multicast_domain                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  694 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_multicast_domain_association             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  695 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_multicast_group_member                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  696 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_multicast_group_source                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  697 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_peering_attachment                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  698 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_peering_attachment_accepter              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  699 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_policy_table                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  700 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_policy_table_association                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  701 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_prefix_list_reference                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  702 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_route                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  703 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_route_table                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  704 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_route_table_association                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  705 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_route_table_propagation                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  706 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_vpc_attachment                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  707 | CKV2_AWS_75 | resource | aws_ec2_transit_gateway_vpc_attachment_accepter                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  708 | CKV2_AWS_75 | resource | aws_ecr_account_setting                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  709 | CKV2_AWS_75 | resource | aws_ecr_lifecycle_policy                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  710 | CKV2_AWS_75 | resource | aws_ecr_pull_through_cache_rule                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  711 | CKV2_AWS_75 | resource | aws_ecr_registry_policy                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  712 | CKV2_AWS_75 | resource | aws_ecr_registry_scanning_configuration                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  713 | CKV2_AWS_75 | resource | aws_ecr_replication_configuration                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  714 | CKV2_AWS_75 | resource | aws_ecr_repository                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  715 | CKV2_AWS_75 | resource | aws_ecr_repository_creation_template                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  716 | CKV2_AWS_75 | resource | aws_ecr_repository_policy                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  717 | CKV2_AWS_75 | resource | aws_ecrpublic_repository                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  718 | CKV2_AWS_75 | resource | aws_ecrpublic_repository_policy                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  719 | CKV2_AWS_75 | resource | aws_ecs_account_setting_default                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  720 | CKV2_AWS_75 | resource | aws_ecs_capacity_provider                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  721 | CKV2_AWS_75 | resource | aws_ecs_cluster                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  722 | CKV2_AWS_75 | resource | aws_ecs_cluster_capacity_providers                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  723 | CKV2_AWS_75 | resource | aws_ecs_service                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  724 | CKV2_AWS_75 | resource | aws_ecs_tag                                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  725 | CKV2_AWS_75 | resource | aws_ecs_task_definition                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  726 | CKV2_AWS_75 | resource | aws_ecs_task_set                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  727 | CKV2_AWS_75 | resource | aws_efs_access_point                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  728 | CKV2_AWS_75 | resource | aws_efs_backup_policy                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  729 | CKV2_AWS_75 | resource | aws_efs_file_system                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  730 | CKV2_AWS_75 | resource | aws_efs_file_system_policy                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  731 | CKV2_AWS_75 | resource | aws_efs_mount_target                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  732 | CKV2_AWS_75 | resource | aws_efs_replication_configuration                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  733 | CKV2_AWS_75 | resource | aws_egress_only_internet_gateway                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  734 | CKV2_AWS_75 | resource | aws_eip                                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  735 | CKV2_AWS_75 | resource | aws_eip_association                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  736 | CKV2_AWS_75 | resource | aws_eip_domain_name                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  737 | CKV2_AWS_75 | resource | aws_eks_access_entry                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  738 | CKV2_AWS_75 | resource | aws_eks_access_policy_association                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  739 | CKV2_AWS_75 | resource | aws_eks_addon                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  740 | CKV2_AWS_75 | resource | aws_eks_cluster                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  741 | CKV2_AWS_75 | resource | aws_eks_fargate_profile                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  742 | CKV2_AWS_75 | resource | aws_eks_identity_provider_config                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  743 | CKV2_AWS_75 | resource | aws_eks_node_group                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  744 | CKV2_AWS_75 | resource | aws_eks_pod_identity_association                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  745 | CKV2_AWS_75 | resource | aws_elastic_beanstalk_application                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  746 | CKV2_AWS_75 | resource | aws_elastic_beanstalk_application_version                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  747 | CKV2_AWS_75 | resource | aws_elastic_beanstalk_configuration_template                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  748 | CKV2_AWS_75 | resource | aws_elastic_beanstalk_environment                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  749 | CKV2_AWS_75 | resource | aws_elasticache_cluster                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  750 | CKV2_AWS_75 | resource | aws_elasticache_global_replication_group                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  751 | CKV2_AWS_75 | resource | aws_elasticache_parameter_group                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  752 | CKV2_AWS_75 | resource | aws_elasticache_replication_group                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  753 | CKV2_AWS_75 | resource | aws_elasticache_reserved_cache_node                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  754 | CKV2_AWS_75 | resource | aws_elasticache_security_group                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  755 | CKV2_AWS_75 | resource | aws_elasticache_serverless_cache                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  756 | CKV2_AWS_75 | resource | aws_elasticache_subnet_group                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  757 | CKV2_AWS_75 | resource | aws_elasticache_user                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  758 | CKV2_AWS_75 | resource | aws_elasticache_user_group                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  759 | CKV2_AWS_75 | resource | aws_elasticache_user_group_association                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  760 | CKV2_AWS_75 | resource | aws_elasticsearch_domain                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  761 | CKV2_AWS_75 | resource | aws_elasticsearch_domain_policy                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  762 | CKV2_AWS_75 | resource | aws_elasticsearch_domain_saml_options                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  763 | CKV2_AWS_75 | resource | aws_elasticsearch_vpc_endpoint                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  764 | CKV2_AWS_75 | resource | aws_elastictranscoder_pipeline                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  765 | CKV2_AWS_75 | resource | aws_elastictranscoder_preset                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  766 | CKV2_AWS_75 | resource | aws_elb                                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  767 | CKV2_AWS_75 | resource | aws_elb_attachment                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  768 | CKV2_AWS_75 | resource | aws_emr_block_public_access_configuration                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  769 | CKV2_AWS_75 | resource | aws_emr_cluster                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  770 | CKV2_AWS_75 | resource | aws_emr_instance_fleet                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  771 | CKV2_AWS_75 | resource | aws_emr_instance_group                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  772 | CKV2_AWS_75 | resource | aws_emr_managed_scaling_policy                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  773 | CKV2_AWS_75 | resource | aws_emr_security_configuration                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  774 | CKV2_AWS_75 | resource | aws_emr_studio                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  775 | CKV2_AWS_75 | resource | aws_emr_studio_session_mapping                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  776 | CKV2_AWS_75 | resource | aws_emrcontainers_job_template                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  777 | CKV2_AWS_75 | resource | aws_emrcontainers_virtual_cluster                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  778 | CKV2_AWS_75 | resource | aws_emrserverless_application                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  779 | CKV2_AWS_75 | resource | aws_evidently_feature                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  780 | CKV2_AWS_75 | resource | aws_evidently_launch                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  781 | CKV2_AWS_75 | resource | aws_evidently_project                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  782 | CKV2_AWS_75 | resource | aws_evidently_segment                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  783 | CKV2_AWS_75 | resource | aws_finspace_kx_cluster                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  784 | CKV2_AWS_75 | resource | aws_finspace_kx_database                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  785 | CKV2_AWS_75 | resource | aws_finspace_kx_dataview                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  786 | CKV2_AWS_75 | resource | aws_finspace_kx_environment                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  787 | CKV2_AWS_75 | resource | aws_finspace_kx_scaling_group                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  788 | CKV2_AWS_75 | resource | aws_finspace_kx_user                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  789 | CKV2_AWS_75 | resource | aws_finspace_kx_volume                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  790 | CKV2_AWS_75 | resource | aws_fis_experiment_template                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  791 | CKV2_AWS_75 | resource | aws_flow_log                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  792 | CKV2_AWS_75 | resource | aws_fms_admin_account                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  793 | CKV2_AWS_75 | resource | aws_fms_policy                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  794 | CKV2_AWS_75 | resource | aws_fms_resource_set                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  795 | CKV2_AWS_75 | resource | aws_fsx_backup                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  796 | CKV2_AWS_75 | resource | aws_fsx_data_repository_association                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  797 | CKV2_AWS_75 | resource | aws_fsx_file_cache                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  798 | CKV2_AWS_75 | resource | aws_fsx_lustre_file_system                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  799 | CKV2_AWS_75 | resource | aws_fsx_ontap_file_system                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  800 | CKV2_AWS_75 | resource | aws_fsx_ontap_storage_virtual_machine                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  801 | CKV2_AWS_75 | resource | aws_fsx_ontap_volume                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  802 | CKV2_AWS_75 | resource | aws_fsx_openzfs_file_system                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  803 | CKV2_AWS_75 | resource | aws_fsx_openzfs_snapshot                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  804 | CKV2_AWS_75 | resource | aws_fsx_openzfs_volume                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  805 | CKV2_AWS_75 | resource | aws_fsx_windows_file_system                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  806 | CKV2_AWS_75 | resource | aws_gamelift_alias                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  807 | CKV2_AWS_75 | resource | aws_gamelift_build                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  808 | CKV2_AWS_75 | resource | aws_gamelift_fleet                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  809 | CKV2_AWS_75 | resource | aws_gamelift_game_server_group                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  810 | CKV2_AWS_75 | resource | aws_gamelift_game_session_queue                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  811 | CKV2_AWS_75 | resource | aws_gamelift_script                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  812 | CKV2_AWS_75 | resource | aws_glacier_vault                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  813 | CKV2_AWS_75 | resource | aws_glacier_vault_lock                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  814 | CKV2_AWS_75 | resource | aws_globalaccelerator_accelerator                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  815 | CKV2_AWS_75 | resource | aws_globalaccelerator_cross_account_attachment                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  816 | CKV2_AWS_75 | resource | aws_globalaccelerator_custom_routing_accelerator                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  817 | CKV2_AWS_75 | resource | aws_globalaccelerator_custom_routing_endpoint_group              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  818 | CKV2_AWS_75 | resource | aws_globalaccelerator_custom_routing_listener                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  819 | CKV2_AWS_75 | resource | aws_globalaccelerator_endpoint_group                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  820 | CKV2_AWS_75 | resource | aws_globalaccelerator_listener                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  821 | CKV2_AWS_75 | resource | aws_glue_catalog_database                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  822 | CKV2_AWS_75 | resource | aws_glue_catalog_table                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  823 | CKV2_AWS_75 | resource | aws_glue_catalog_table_optimizer                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  824 | CKV2_AWS_75 | resource | aws_glue_classifier                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  825 | CKV2_AWS_75 | resource | aws_glue_connection                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  826 | CKV2_AWS_75 | resource | aws_glue_crawler                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  827 | CKV2_AWS_75 | resource | aws_glue_data_catalog_encryption_settings                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  828 | CKV2_AWS_75 | resource | aws_glue_data_quality_ruleset                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  829 | CKV2_AWS_75 | resource | aws_glue_dev_endpoint                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  830 | CKV2_AWS_75 | resource | aws_glue_job                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  831 | CKV2_AWS_75 | resource | aws_glue_ml_transform                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  832 | CKV2_AWS_75 | resource | aws_glue_partition                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  833 | CKV2_AWS_75 | resource | aws_glue_partition_index                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  834 | CKV2_AWS_75 | resource | aws_glue_registry                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  835 | CKV2_AWS_75 | resource | aws_glue_resource_policy                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  836 | CKV2_AWS_75 | resource | aws_glue_schema                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  837 | CKV2_AWS_75 | resource | aws_glue_security_configuration                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  838 | CKV2_AWS_75 | resource | aws_glue_trigger                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  839 | CKV2_AWS_75 | resource | aws_glue_user_defined_function                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  840 | CKV2_AWS_75 | resource | aws_glue_workflow                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  841 | CKV2_AWS_75 | resource | aws_grafana_license_association                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  842 | CKV2_AWS_75 | resource | aws_grafana_role_association                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  843 | CKV2_AWS_75 | resource | aws_grafana_workspace                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  844 | CKV2_AWS_75 | resource | aws_grafana_workspace_api_key                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  845 | CKV2_AWS_75 | resource | aws_grafana_workspace_saml_configuration                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  846 | CKV2_AWS_75 | resource | aws_grafana_workspace_service_account                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  847 | CKV2_AWS_75 | resource | aws_grafana_workspace_service_account_token                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  848 | CKV2_AWS_75 | resource | aws_guardduty_detector                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  849 | CKV2_AWS_75 | resource | aws_guardduty_detector_feature                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  850 | CKV2_AWS_75 | resource | aws_guardduty_filter                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  851 | CKV2_AWS_75 | resource | aws_guardduty_invite_accepter                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  852 | CKV2_AWS_75 | resource | aws_guardduty_ipset                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  853 | CKV2_AWS_75 | resource | aws_guardduty_malware_protection_plan                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  854 | CKV2_AWS_75 | resource | aws_guardduty_member                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  855 | CKV2_AWS_75 | resource | aws_guardduty_member_detector_feature                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  856 | CKV2_AWS_75 | resource | aws_guardduty_organization_admin_account                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  857 | CKV2_AWS_75 | resource | aws_guardduty_organization_configuration                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  858 | CKV2_AWS_75 | resource | aws_guardduty_organization_configuration_feature                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  859 | CKV2_AWS_75 | resource | aws_guardduty_publishing_destination                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  860 | CKV2_AWS_75 | resource | aws_guardduty_threatintelset                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  861 | CKV2_AWS_75 | resource | aws_iam_access_key                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  862 | CKV2_AWS_75 | resource | aws_iam_account_alias                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  863 | CKV2_AWS_75 | resource | aws_iam_account_password_policy                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  864 | CKV2_AWS_75 | resource | aws_iam_group                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  865 | CKV2_AWS_75 | resource | aws_iam_group_membership                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  866 | CKV2_AWS_75 | resource | aws_iam_group_policies_exclusive                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  867 | CKV2_AWS_75 | resource | aws_iam_group_policy                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  868 | CKV2_AWS_75 | resource | aws_iam_group_policy_attachment                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  869 | CKV2_AWS_75 | resource | aws_iam_group_policy_attachments_exclusive                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  870 | CKV2_AWS_75 | resource | aws_iam_instance_profile                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  871 | CKV2_AWS_75 | resource | aws_iam_openid_connect_provider                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  872 | CKV2_AWS_75 | resource | aws_iam_organizations_features                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  873 | CKV2_AWS_75 | resource | aws_iam_policy                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  874 | CKV2_AWS_75 | resource | aws_iam_policy_attachment                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  875 | CKV2_AWS_75 | resource | aws_iam_policy_document                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  876 | CKV2_AWS_75 | resource | aws_iam_role                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  877 | CKV2_AWS_75 | resource | aws_iam_role_policies_exclusive                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  878 | CKV2_AWS_75 | resource | aws_iam_role_policy                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  879 | CKV2_AWS_75 | resource | aws_iam_role_policy_attachment                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  880 | CKV2_AWS_75 | resource | aws_iam_role_policy_attachments_exclusive                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  881 | CKV2_AWS_75 | resource | aws_iam_saml_provider                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  882 | CKV2_AWS_75 | resource | aws_iam_security_token_service_preferences                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  883 | CKV2_AWS_75 | resource | aws_iam_server_certificate                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  884 | CKV2_AWS_75 | resource | aws_iam_service_linked_role                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  885 | CKV2_AWS_75 | resource | aws_iam_service_specific_credential                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  886 | CKV2_AWS_75 | resource | aws_iam_signing_certificate                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  887 | CKV2_AWS_75 | resource | aws_iam_user                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  888 | CKV2_AWS_75 | resource | aws_iam_user_group_membership                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  889 | CKV2_AWS_75 | resource | aws_iam_user_login_profile                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  890 | CKV2_AWS_75 | resource | aws_iam_user_policies_exclusive                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  891 | CKV2_AWS_75 | resource | aws_iam_user_policy                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  892 | CKV2_AWS_75 | resource | aws_iam_user_policy_attachment                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  893 | CKV2_AWS_75 | resource | aws_iam_user_policy_attachments_exclusive                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  894 | CKV2_AWS_75 | resource | aws_iam_user_ssh_key                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  895 | CKV2_AWS_75 | resource | aws_iam_virtual_mfa_device                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  896 | CKV2_AWS_75 | resource | aws_identitystore_group                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  897 | CKV2_AWS_75 | resource | aws_identitystore_group_membership                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  898 | CKV2_AWS_75 | resource | aws_identitystore_user                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  899 | CKV2_AWS_75 | resource | aws_imagebuilder_component                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  900 | CKV2_AWS_75 | resource | aws_imagebuilder_container_recipe                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  901 | CKV2_AWS_75 | resource | aws_imagebuilder_distribution_configuration                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  902 | CKV2_AWS_75 | resource | aws_imagebuilder_image                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  903 | CKV2_AWS_75 | resource | aws_imagebuilder_image_pipeline                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  904 | CKV2_AWS_75 | resource | aws_imagebuilder_image_recipe                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  905 | CKV2_AWS_75 | resource | aws_imagebuilder_infrastructure_configuration                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  906 | CKV2_AWS_75 | resource | aws_imagebuilder_lifecycle_policy                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  907 | CKV2_AWS_75 | resource | aws_imagebuilder_workflow                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  908 | CKV2_AWS_75 | resource | aws_inspector2_delegated_admin_account                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  909 | CKV2_AWS_75 | resource | aws_inspector2_enabler                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  910 | CKV2_AWS_75 | resource | aws_inspector2_member_association                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  911 | CKV2_AWS_75 | resource | aws_inspector2_organization_configuration                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  912 | CKV2_AWS_75 | resource | aws_inspector_assessment_target                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  913 | CKV2_AWS_75 | resource | aws_inspector_assessment_template                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  914 | CKV2_AWS_75 | resource | aws_inspector_resource_group                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  915 | CKV2_AWS_75 | resource | aws_instance                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  916 | CKV2_AWS_75 | resource | aws_internet_gateway                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  917 | CKV2_AWS_75 | resource | aws_internet_gateway_attachment                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  918 | CKV2_AWS_75 | resource | aws_internetmonitor_monitor                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  919 | CKV2_AWS_75 | resource | aws_iot_authorizer                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  920 | CKV2_AWS_75 | resource | aws_iot_billing_group                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  921 | CKV2_AWS_75 | resource | aws_iot_ca_certificate                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  922 | CKV2_AWS_75 | resource | aws_iot_certificate                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  923 | CKV2_AWS_75 | resource | aws_iot_domain_configuration                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  924 | CKV2_AWS_75 | resource | aws_iot_event_configurations                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  925 | CKV2_AWS_75 | resource | aws_iot_indexing_configuration                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  926 | CKV2_AWS_75 | resource | aws_iot_logging_options                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  927 | CKV2_AWS_75 | resource | aws_iot_policy                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  928 | CKV2_AWS_75 | resource | aws_iot_policy_attachment                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  929 | CKV2_AWS_75 | resource | aws_iot_provisioning_template                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  930 | CKV2_AWS_75 | resource | aws_iot_role_alias                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  931 | CKV2_AWS_75 | resource | aws_iot_thing                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  932 | CKV2_AWS_75 | resource | aws_iot_thing_group                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  933 | CKV2_AWS_75 | resource | aws_iot_thing_group_membership                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  934 | CKV2_AWS_75 | resource | aws_iot_thing_principal_attachment                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  935 | CKV2_AWS_75 | resource | aws_iot_thing_type                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  936 | CKV2_AWS_75 | resource | aws_iot_topic_rule                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  937 | CKV2_AWS_75 | resource | aws_iot_topic_rule_destination                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  938 | CKV2_AWS_75 | resource | aws_ivs_channel                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  939 | CKV2_AWS_75 | resource | aws_ivs_playback_key_pair                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  940 | CKV2_AWS_75 | resource | aws_ivs_recording_configuration                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  941 | CKV2_AWS_75 | resource | aws_ivschat_logging_configuration                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  942 | CKV2_AWS_75 | resource | aws_ivschat_room                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  943 | CKV2_AWS_75 | resource | aws_kendra_data_source                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  944 | CKV2_AWS_75 | resource | aws_kendra_experience                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  945 | CKV2_AWS_75 | resource | aws_kendra_faq                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  946 | CKV2_AWS_75 | resource | aws_kendra_index                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  947 | CKV2_AWS_75 | resource | aws_kendra_query_suggestions_block_list                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  948 | CKV2_AWS_75 | resource | aws_kendra_thesaurus                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  949 | CKV2_AWS_75 | resource | aws_key_pair                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  950 | CKV2_AWS_75 | resource | aws_keyspaces_keyspace                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  951 | CKV2_AWS_75 | resource | aws_keyspaces_table                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  952 | CKV2_AWS_75 | resource | aws_kinesis_analytics_application                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  953 | CKV2_AWS_75 | resource | aws_kinesis_firehose_delivery_stream                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  954 | CKV2_AWS_75 | resource | aws_kinesis_resource_policy                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  955 | CKV2_AWS_75 | resource | aws_kinesis_stream                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  956 | CKV2_AWS_75 | resource | aws_kinesis_stream_consumer                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  957 | CKV2_AWS_75 | resource | aws_kinesis_video_stream                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  958 | CKV2_AWS_75 | resource | aws_kinesisanalyticsv2_application                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  959 | CKV2_AWS_75 | resource | aws_kinesisanalyticsv2_application_snapshot                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  960 | CKV2_AWS_75 | resource | aws_kms_alias                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  961 | CKV2_AWS_75 | resource | aws_kms_ciphertext                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  962 | CKV2_AWS_75 | resource | aws_kms_custom_key_store                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  963 | CKV2_AWS_75 | resource | aws_kms_external_key                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  964 | CKV2_AWS_75 | resource | aws_kms_grant                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  965 | CKV2_AWS_75 | resource | aws_kms_key                                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  966 | CKV2_AWS_75 | resource | aws_kms_key_policy                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  967 | CKV2_AWS_75 | resource | aws_kms_replica_external_key                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  968 | CKV2_AWS_75 | resource | aws_kms_replica_key                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  969 | CKV2_AWS_75 | resource | aws_lakeformation_data_cells_filter                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  970 | CKV2_AWS_75 | resource | aws_lakeformation_data_lake_settings                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  971 | CKV2_AWS_75 | resource | aws_lakeformation_lf_tag                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  972 | CKV2_AWS_75 | resource | aws_lakeformation_permissions                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  973 | CKV2_AWS_75 | resource | aws_lakeformation_resource                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  974 | CKV2_AWS_75 | resource | aws_lakeformation_resource_lf_tag                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  975 | CKV2_AWS_75 | resource | aws_lakeformation_resource_lf_tags                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  976 | CKV2_AWS_75 | resource | aws_lambda_alias                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  977 | CKV2_AWS_75 | resource | aws_lambda_code_signing_config                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  978 | CKV2_AWS_75 | resource | aws_lambda_event_source_mapping                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  979 | CKV2_AWS_75 | resource | aws_lambda_function                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  980 | CKV2_AWS_75 | resource | aws_lambda_function_event_invoke_config                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  981 | CKV2_AWS_75 | resource | aws_lambda_function_recursion_config                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  982 | CKV2_AWS_75 | resource | aws_lambda_function_url                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  983 | CKV2_AWS_75 | resource | aws_lambda_invocation                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  984 | CKV2_AWS_75 | resource | aws_lambda_layer_version                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  985 | CKV2_AWS_75 | resource | aws_lambda_layer_version_permission                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  986 | CKV2_AWS_75 | resource | aws_lambda_permission                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  987 | CKV2_AWS_75 | resource | aws_lambda_provisioned_concurrency_config                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  988 | CKV2_AWS_75 | resource | aws_lambda_runtime_management_config                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  989 | CKV2_AWS_75 | resource | aws_launch_configuration                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  990 | CKV2_AWS_75 | resource | aws_launch_template                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  991 | CKV2_AWS_75 | resource | aws_lb                                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  992 | CKV2_AWS_75 | resource | aws_lb_cookie_stickiness_policy                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  993 | CKV2_AWS_75 | resource | aws_lb_listener                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  994 | CKV2_AWS_75 | resource | aws_lb_listener_certificate                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  995 | CKV2_AWS_75 | resource | aws_lb_listener_rule                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  996 | CKV2_AWS_75 | resource | aws_lb_ssl_negotiation_policy                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  997 | CKV2_AWS_75 | resource | aws_lb_target_group                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  998 | CKV2_AWS_75 | resource | aws_lb_target_group_attachment                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
|  999 | CKV2_AWS_75 | resource | aws_lb_trust_store                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1000 | CKV2_AWS_75 | resource | aws_lb_trust_store_revocation                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1001 | CKV2_AWS_75 | resource | aws_lex_bot                                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1002 | CKV2_AWS_75 | resource | aws_lex_bot_alias                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1003 | CKV2_AWS_75 | resource | aws_lex_intent                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1004 | CKV2_AWS_75 | resource | aws_lex_slot_type                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1005 | CKV2_AWS_75 | resource | aws_lexv2models_bot                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1006 | CKV2_AWS_75 | resource | aws_lexv2models_bot_locale                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1007 | CKV2_AWS_75 | resource | aws_lexv2models_bot_version                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1008 | CKV2_AWS_75 | resource | aws_lexv2models_intent                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1009 | CKV2_AWS_75 | resource | aws_lexv2models_slot                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1010 | CKV2_AWS_75 | resource | aws_lexv2models_slot_type                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1011 | CKV2_AWS_75 | resource | aws_licensemanager_association                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1012 | CKV2_AWS_75 | resource | aws_licensemanager_grant                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1013 | CKV2_AWS_75 | resource | aws_licensemanager_grant_accepter                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1014 | CKV2_AWS_75 | resource | aws_licensemanager_license_configuration                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1015 | CKV2_AWS_75 | resource | aws_lightsail_bucket                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1016 | CKV2_AWS_75 | resource | aws_lightsail_bucket_access_key                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1017 | CKV2_AWS_75 | resource | aws_lightsail_bucket_resource_access                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1018 | CKV2_AWS_75 | resource | aws_lightsail_certificate                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1019 | CKV2_AWS_75 | resource | aws_lightsail_container_service                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1020 | CKV2_AWS_75 | resource | aws_lightsail_container_service_deployment_version               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1021 | CKV2_AWS_75 | resource | aws_lightsail_database                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1022 | CKV2_AWS_75 | resource | aws_lightsail_disk                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1023 | CKV2_AWS_75 | resource | aws_lightsail_disk_attachment                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1024 | CKV2_AWS_75 | resource | aws_lightsail_distribution                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1025 | CKV2_AWS_75 | resource | aws_lightsail_domain                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1026 | CKV2_AWS_75 | resource | aws_lightsail_domain_entry                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1027 | CKV2_AWS_75 | resource | aws_lightsail_instance                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1028 | CKV2_AWS_75 | resource | aws_lightsail_instance_public_ports                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1029 | CKV2_AWS_75 | resource | aws_lightsail_key_pair                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1030 | CKV2_AWS_75 | resource | aws_lightsail_lb                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1031 | CKV2_AWS_75 | resource | aws_lightsail_lb_attachment                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1032 | CKV2_AWS_75 | resource | aws_lightsail_lb_certificate                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1033 | CKV2_AWS_75 | resource | aws_lightsail_lb_certificate_attachment                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1034 | CKV2_AWS_75 | resource | aws_lightsail_lb_https_redirection_policy                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1035 | CKV2_AWS_75 | resource | aws_lightsail_lb_stickiness_policy                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1036 | CKV2_AWS_75 | resource | aws_lightsail_static_ip                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1037 | CKV2_AWS_75 | resource | aws_lightsail_static_ip_attachment                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1038 | CKV2_AWS_75 | resource | aws_load_balancer_backend_server_policy                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1039 | CKV2_AWS_75 | resource | aws_load_balancer_listener_policy                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1040 | CKV2_AWS_75 | resource | aws_load_balancer_policy                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1041 | CKV2_AWS_75 | resource | aws_location_geofence_collection                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1042 | CKV2_AWS_75 | resource | aws_location_map                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1043 | CKV2_AWS_75 | resource | aws_location_place_index                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1044 | CKV2_AWS_75 | resource | aws_location_route_calculator                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1045 | CKV2_AWS_75 | resource | aws_location_tracker                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1046 | CKV2_AWS_75 | resource | aws_location_tracker_association                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1047 | CKV2_AWS_75 | resource | aws_m2_application                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1048 | CKV2_AWS_75 | resource | aws_m2_deployment                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1049 | CKV2_AWS_75 | resource | aws_m2_environment                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1050 | CKV2_AWS_75 | resource | aws_macie2_account                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1051 | CKV2_AWS_75 | resource | aws_macie2_classification_export_configuration                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1052 | CKV2_AWS_75 | resource | aws_macie2_classification_job                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1053 | CKV2_AWS_75 | resource | aws_macie2_custom_data_identifier                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1054 | CKV2_AWS_75 | resource | aws_macie2_findings_filter                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1055 | CKV2_AWS_75 | resource | aws_macie2_invitation_accepter                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1056 | CKV2_AWS_75 | resource | aws_macie2_member                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1057 | CKV2_AWS_75 | resource | aws_macie2_organization_admin_account                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1058 | CKV2_AWS_75 | resource | aws_macie_member_account_association                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1059 | CKV2_AWS_75 | resource | aws_macie_s3_bucket_association                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1060 | CKV2_AWS_75 | resource | aws_main_route_table_association                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1061 | CKV2_AWS_75 | resource | aws_media_convert_queue                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1062 | CKV2_AWS_75 | resource | aws_media_package_channel                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1063 | CKV2_AWS_75 | resource | aws_media_packagev2_channel_group                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1064 | CKV2_AWS_75 | resource | aws_media_store_container                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1065 | CKV2_AWS_75 | resource | aws_media_store_container_policy                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1066 | CKV2_AWS_75 | resource | aws_medialive_channel                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1067 | CKV2_AWS_75 | resource | aws_medialive_input                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1068 | CKV2_AWS_75 | resource | aws_medialive_input_security_group                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1069 | CKV2_AWS_75 | resource | aws_medialive_multiplex                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1070 | CKV2_AWS_75 | resource | aws_medialive_multiplex_program                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1071 | CKV2_AWS_75 | resource | aws_memorydb_acl                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1072 | CKV2_AWS_75 | resource | aws_memorydb_cluster                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1073 | CKV2_AWS_75 | resource | aws_memorydb_multi_region_cluster                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1074 | CKV2_AWS_75 | resource | aws_memorydb_parameter_group                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1075 | CKV2_AWS_75 | resource | aws_memorydb_snapshot                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1076 | CKV2_AWS_75 | resource | aws_memorydb_subnet_group                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1077 | CKV2_AWS_75 | resource | aws_memorydb_user                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1078 | CKV2_AWS_75 | resource | aws_mq_broker                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1079 | CKV2_AWS_75 | resource | aws_mq_configuration                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1080 | CKV2_AWS_75 | resource | aws_msk_cluster                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1081 | CKV2_AWS_75 | resource | aws_msk_cluster_policy                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1082 | CKV2_AWS_75 | resource | aws_msk_configuration                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1083 | CKV2_AWS_75 | resource | aws_msk_replicator                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1084 | CKV2_AWS_75 | resource | aws_msk_scram_secret_association                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1085 | CKV2_AWS_75 | resource | aws_msk_serverless_cluster                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1086 | CKV2_AWS_75 | resource | aws_msk_single_scram_secret_association                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1087 | CKV2_AWS_75 | resource | aws_msk_vpc_connection                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1088 | CKV2_AWS_75 | resource | aws_mskconnect_connector                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1089 | CKV2_AWS_75 | resource | aws_mskconnect_custom_plugin                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1090 | CKV2_AWS_75 | resource | aws_mskconnect_worker_configuration                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1091 | CKV2_AWS_75 | resource | aws_mwaa_environment                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1092 | CKV2_AWS_75 | resource | aws_nat_gateway                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1093 | CKV2_AWS_75 | resource | aws_neptune_cluster                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1094 | CKV2_AWS_75 | resource | aws_neptune_cluster_endpoint                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1095 | CKV2_AWS_75 | resource | aws_neptune_cluster_instance                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1096 | CKV2_AWS_75 | resource | aws_neptune_cluster_parameter_group                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1097 | CKV2_AWS_75 | resource | aws_neptune_cluster_snapshot                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1098 | CKV2_AWS_75 | resource | aws_neptune_event_subscription                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1099 | CKV2_AWS_75 | resource | aws_neptune_global_cluster                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1100 | CKV2_AWS_75 | resource | aws_neptune_parameter_group                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1101 | CKV2_AWS_75 | resource | aws_neptune_subnet_group                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1102 | CKV2_AWS_75 | resource | aws_network_acl                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1103 | CKV2_AWS_75 | resource | aws_network_acl_association                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1104 | CKV2_AWS_75 | resource | aws_network_acl_rule                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1105 | CKV2_AWS_75 | resource | aws_network_interface                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1106 | CKV2_AWS_75 | resource | aws_network_interface_attachment                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1107 | CKV2_AWS_75 | resource | aws_network_interface_sg_attachment                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1108 | CKV2_AWS_75 | resource | aws_networkfirewall_firewall                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1109 | CKV2_AWS_75 | resource | aws_networkfirewall_firewall_policy                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1110 | CKV2_AWS_75 | resource | aws_networkfirewall_logging_configuration                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1111 | CKV2_AWS_75 | resource | aws_networkfirewall_resource_policy                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1112 | CKV2_AWS_75 | resource | aws_networkfirewall_rule_group                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1113 | CKV2_AWS_75 | resource | aws_networkfirewall_tls_inspection_configuration                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1114 | CKV2_AWS_75 | resource | aws_networkmanager_attachment_accepter                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1115 | CKV2_AWS_75 | resource | aws_networkmanager_connect_attachment                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1116 | CKV2_AWS_75 | resource | aws_networkmanager_connect_peer                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1117 | CKV2_AWS_75 | resource | aws_networkmanager_connection                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1118 | CKV2_AWS_75 | resource | aws_networkmanager_core_network                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1119 | CKV2_AWS_75 | resource | aws_networkmanager_core_network_policy_attachment                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1120 | CKV2_AWS_75 | resource | aws_networkmanager_customer_gateway_association                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1121 | CKV2_AWS_75 | resource | aws_networkmanager_device                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1122 | CKV2_AWS_75 | resource | aws_networkmanager_dx_gateway_attachment                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1123 | CKV2_AWS_75 | resource | aws_networkmanager_global_network                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1124 | CKV2_AWS_75 | resource | aws_networkmanager_link                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1125 | CKV2_AWS_75 | resource | aws_networkmanager_link_association                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1126 | CKV2_AWS_75 | resource | aws_networkmanager_site                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1127 | CKV2_AWS_75 | resource | aws_networkmanager_site_to_site_vpn_attachment                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1128 | CKV2_AWS_75 | resource | aws_networkmanager_transit_gateway_connect_peer_association      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1129 | CKV2_AWS_75 | resource | aws_networkmanager_transit_gateway_peering                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1130 | CKV2_AWS_75 | resource | aws_networkmanager_transit_gateway_registration                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1131 | CKV2_AWS_75 | resource | aws_networkmanager_transit_gateway_route_table_attachment        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1132 | CKV2_AWS_75 | resource | aws_networkmanager_vpc_attachment                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1133 | CKV2_AWS_75 | resource | aws_networkmonitor_monitor                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1134 | CKV2_AWS_75 | resource | aws_networkmonitor_probe                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1135 | CKV2_AWS_75 | resource | aws_oam_link                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1136 | CKV2_AWS_75 | resource | aws_oam_sink                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1137 | CKV2_AWS_75 | resource | aws_oam_sink_policy                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1138 | CKV2_AWS_75 | resource | aws_opensearch_authorize_vpc_endpoint_access                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1139 | CKV2_AWS_75 | resource | aws_opensearch_domain                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1140 | CKV2_AWS_75 | resource | aws_opensearch_domain_policy                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1141 | CKV2_AWS_75 | resource | aws_opensearch_domain_saml_options                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1142 | CKV2_AWS_75 | resource | aws_opensearch_inbound_connection_accepter                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1143 | CKV2_AWS_75 | resource | aws_opensearch_outbound_connection                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1144 | CKV2_AWS_75 | resource | aws_opensearch_package                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1145 | CKV2_AWS_75 | resource | aws_opensearch_package_association                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1146 | CKV2_AWS_75 | resource | aws_opensearch_vpc_endpoint                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1147 | CKV2_AWS_75 | resource | aws_opensearchserverless_access_policy                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1148 | CKV2_AWS_75 | resource | aws_opensearchserverless_collection                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1149 | CKV2_AWS_75 | resource | aws_opensearchserverless_lifecycle_policy                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1150 | CKV2_AWS_75 | resource | aws_opensearchserverless_security_config                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1151 | CKV2_AWS_75 | resource | aws_opensearchserverless_security_policy                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1152 | CKV2_AWS_75 | resource | aws_opensearchserverless_vpc_endpoint                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1153 | CKV2_AWS_75 | resource | aws_opsworks_application                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1154 | CKV2_AWS_75 | resource | aws_opsworks_custom_layer                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1155 | CKV2_AWS_75 | resource | aws_opsworks_ecs_cluster_layer                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1156 | CKV2_AWS_75 | resource | aws_opsworks_ganglia_layer                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1157 | CKV2_AWS_75 | resource | aws_opsworks_haproxy_layer                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1158 | CKV2_AWS_75 | resource | aws_opsworks_instance                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1159 | CKV2_AWS_75 | resource | aws_opsworks_java_app_layer                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1160 | CKV2_AWS_75 | resource | aws_opsworks_memcached_layer                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1161 | CKV2_AWS_75 | resource | aws_opsworks_mysql_layer                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1162 | CKV2_AWS_75 | resource | aws_opsworks_nodejs_app_layer                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1163 | CKV2_AWS_75 | resource | aws_opsworks_permission                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1164 | CKV2_AWS_75 | resource | aws_opsworks_php_app_layer                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1165 | CKV2_AWS_75 | resource | aws_opsworks_rails_app_layer                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1166 | CKV2_AWS_75 | resource | aws_opsworks_rds_db_instance                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1167 | CKV2_AWS_75 | resource | aws_opsworks_stack                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1168 | CKV2_AWS_75 | resource | aws_opsworks_static_web_layer                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1169 | CKV2_AWS_75 | resource | aws_opsworks_user_profile                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1170 | CKV2_AWS_75 | resource | aws_organizations_account                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1171 | CKV2_AWS_75 | resource | aws_organizations_delegated_administrator                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1172 | CKV2_AWS_75 | resource | aws_organizations_organization                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1173 | CKV2_AWS_75 | resource | aws_organizations_organizational_unit                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1174 | CKV2_AWS_75 | resource | aws_organizations_policy                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1175 | CKV2_AWS_75 | resource | aws_organizations_policy_attachment                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1176 | CKV2_AWS_75 | resource | aws_organizations_resource_policy                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1177 | CKV2_AWS_75 | resource | aws_osis_pipeline                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1178 | CKV2_AWS_75 | resource | aws_paymentcryptography_key                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1179 | CKV2_AWS_75 | resource | aws_paymentcryptography_key_alias                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1180 | CKV2_AWS_75 | resource | aws_pinpoint_adm_channel                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1181 | CKV2_AWS_75 | resource | aws_pinpoint_apns_channel                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1182 | CKV2_AWS_75 | resource | aws_pinpoint_apns_sandbox_channel                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1183 | CKV2_AWS_75 | resource | aws_pinpoint_apns_voip_channel                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1184 | CKV2_AWS_75 | resource | aws_pinpoint_apns_voip_sandbox_channel                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1185 | CKV2_AWS_75 | resource | aws_pinpoint_app                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1186 | CKV2_AWS_75 | resource | aws_pinpoint_baidu_channel                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1187 | CKV2_AWS_75 | resource | aws_pinpoint_email_channel                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1188 | CKV2_AWS_75 | resource | aws_pinpoint_email_template                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1189 | CKV2_AWS_75 | resource | aws_pinpoint_event_stream                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1190 | CKV2_AWS_75 | resource | aws_pinpoint_gcm_channel                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1191 | CKV2_AWS_75 | resource | aws_pinpoint_sms_channel                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1192 | CKV2_AWS_75 | resource | aws_pinpointsmsvoicev2_configuration_set                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1193 | CKV2_AWS_75 | resource | aws_pinpointsmsvoicev2_opt_out_list                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1194 | CKV2_AWS_75 | resource | aws_pinpointsmsvoicev2_phone_number                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1195 | CKV2_AWS_75 | resource | aws_pipes_pipe                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1196 | CKV2_AWS_75 | resource | aws_placement_group                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1197 | CKV2_AWS_75 | resource | aws_prometheus_alert_manager_definition                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1198 | CKV2_AWS_75 | resource | aws_prometheus_rule_group_namespace                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1199 | CKV2_AWS_75 | resource | aws_prometheus_scraper                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1200 | CKV2_AWS_75 | resource | aws_prometheus_workspace                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1201 | CKV2_AWS_75 | resource | aws_proxy_protocol_policy                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1202 | CKV2_AWS_75 | resource | aws_qldb_ledger                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1203 | CKV2_AWS_75 | resource | aws_qldb_stream                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1204 | CKV2_AWS_75 | resource | aws_quicksight_account_subscription                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1205 | CKV2_AWS_75 | resource | aws_quicksight_analysis                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1206 | CKV2_AWS_75 | resource | aws_quicksight_dashboard                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1207 | CKV2_AWS_75 | resource | aws_quicksight_data_set                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1208 | CKV2_AWS_75 | resource | aws_quicksight_data_source                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1209 | CKV2_AWS_75 | resource | aws_quicksight_folder                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1210 | CKV2_AWS_75 | resource | aws_quicksight_folder_membership                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1211 | CKV2_AWS_75 | resource | aws_quicksight_group                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1212 | CKV2_AWS_75 | resource | aws_quicksight_group_membership                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1213 | CKV2_AWS_75 | resource | aws_quicksight_iam_policy_assignment                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1214 | CKV2_AWS_75 | resource | aws_quicksight_ingestion                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1215 | CKV2_AWS_75 | resource | aws_quicksight_namespace                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1216 | CKV2_AWS_75 | resource | aws_quicksight_refresh_schedule                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1217 | CKV2_AWS_75 | resource | aws_quicksight_template                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1218 | CKV2_AWS_75 | resource | aws_quicksight_template_alias                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1219 | CKV2_AWS_75 | resource | aws_quicksight_theme                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1220 | CKV2_AWS_75 | resource | aws_quicksight_user                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1221 | CKV2_AWS_75 | resource | aws_quicksight_vpc_connection                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1222 | CKV2_AWS_75 | resource | aws_ram_principal_association                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1223 | CKV2_AWS_75 | resource | aws_ram_resource_association                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1224 | CKV2_AWS_75 | resource | aws_ram_resource_share                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1225 | CKV2_AWS_75 | resource | aws_ram_resource_share_accepter                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1226 | CKV2_AWS_75 | resource | aws_ram_sharing_with_organization                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1227 | CKV2_AWS_75 | resource | aws_rbin_rule                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1228 | CKV2_AWS_75 | resource | aws_rds_certificate                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1229 | CKV2_AWS_75 | resource | aws_rds_cluster                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1230 | CKV2_AWS_75 | resource | aws_rds_cluster_activity_stream                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1231 | CKV2_AWS_75 | resource | aws_rds_cluster_endpoint                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1232 | CKV2_AWS_75 | resource | aws_rds_cluster_instance                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1233 | CKV2_AWS_75 | resource | aws_rds_cluster_parameter_group                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1234 | CKV2_AWS_75 | resource | aws_rds_cluster_role_association                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1235 | CKV2_AWS_75 | resource | aws_rds_cluster_snapshot_copy                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1236 | CKV2_AWS_75 | resource | aws_rds_custom_db_engine_version                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1237 | CKV2_AWS_75 | resource | aws_rds_export_task                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1238 | CKV2_AWS_75 | resource | aws_rds_global_cluster                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1239 | CKV2_AWS_75 | resource | aws_rds_instance_state                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1240 | CKV2_AWS_75 | resource | aws_rds_integration                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1241 | CKV2_AWS_75 | resource | aws_rds_reserved_instance                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1242 | CKV2_AWS_75 | resource | aws_redshift_authentication_profile                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1243 | CKV2_AWS_75 | resource | aws_redshift_cluster                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1244 | CKV2_AWS_75 | resource | aws_redshift_cluster_iam_roles                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1245 | CKV2_AWS_75 | resource | aws_redshift_cluster_snapshot                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1246 | CKV2_AWS_75 | resource | aws_redshift_data_share_authorization                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1247 | CKV2_AWS_75 | resource | aws_redshift_data_share_consumer_association                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1248 | CKV2_AWS_75 | resource | aws_redshift_endpoint_access                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1249 | CKV2_AWS_75 | resource | aws_redshift_endpoint_authorization                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1250 | CKV2_AWS_75 | resource | aws_redshift_event_subscription                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1251 | CKV2_AWS_75 | resource | aws_redshift_hsm_client_certificate                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1252 | CKV2_AWS_75 | resource | aws_redshift_hsm_configuration                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1253 | CKV2_AWS_75 | resource | aws_redshift_logging                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1254 | CKV2_AWS_75 | resource | aws_redshift_parameter_group                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1255 | CKV2_AWS_75 | resource | aws_redshift_partner                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1256 | CKV2_AWS_75 | resource | aws_redshift_resource_policy                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1257 | CKV2_AWS_75 | resource | aws_redshift_scheduled_action                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1258 | CKV2_AWS_75 | resource | aws_redshift_security_group                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1259 | CKV2_AWS_75 | resource | aws_redshift_snapshot_copy                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1260 | CKV2_AWS_75 | resource | aws_redshift_snapshot_copy_grant                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1261 | CKV2_AWS_75 | resource | aws_redshift_snapshot_schedule                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1262 | CKV2_AWS_75 | resource | aws_redshift_snapshot_schedule_association                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1263 | CKV2_AWS_75 | resource | aws_redshift_subnet_group                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1264 | CKV2_AWS_75 | resource | aws_redshift_usage_limit                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1265 | CKV2_AWS_75 | resource | aws_redshiftdata_statement                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1266 | CKV2_AWS_75 | resource | aws_redshiftserverless_custom_domain_association                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1267 | CKV2_AWS_75 | resource | aws_redshiftserverless_endpoint_access                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1268 | CKV2_AWS_75 | resource | aws_redshiftserverless_namespace                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1269 | CKV2_AWS_75 | resource | aws_redshiftserverless_resource_policy                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1270 | CKV2_AWS_75 | resource | aws_redshiftserverless_snapshot                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1271 | CKV2_AWS_75 | resource | aws_redshiftserverless_usage_limit                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1272 | CKV2_AWS_75 | resource | aws_redshiftserverless_workgroup                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1273 | CKV2_AWS_75 | resource | aws_region_info                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1274 | CKV2_AWS_75 | resource | aws_rekognition_collection                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1275 | CKV2_AWS_75 | resource | aws_rekognition_project                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1276 | CKV2_AWS_75 | resource | aws_rekognition_stream_processor                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1277 | CKV2_AWS_75 | resource | aws_resiliencehub_resiliency_policy                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1278 | CKV2_AWS_75 | resource | aws_resourceexplorer2_index                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1279 | CKV2_AWS_75 | resource | aws_resourceexplorer2_view                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1280 | CKV2_AWS_75 | resource | aws_resourcegroups_group                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1281 | CKV2_AWS_75 | resource | aws_resourcegroups_resource                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1282 | CKV2_AWS_75 | resource | aws_rolesanywhere_profile                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1283 | CKV2_AWS_75 | resource | aws_rolesanywhere_trust_anchor                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1284 | CKV2_AWS_75 | resource | aws_root                                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1285 | CKV2_AWS_75 | resource | aws_root_access_key                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1286 | CKV2_AWS_75 | resource | aws_route                                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1287 | CKV2_AWS_75 | resource | aws_route53_cidr_collection                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1288 | CKV2_AWS_75 | resource | aws_route53_cidr_location                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1289 | CKV2_AWS_75 | resource | aws_route53_delegation_set                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1290 | CKV2_AWS_75 | resource | aws_route53_health_check                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1291 | CKV2_AWS_75 | resource | aws_route53_hosted_zone_dnssec                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1292 | CKV2_AWS_75 | resource | aws_route53_key_signing_key                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1293 | CKV2_AWS_75 | resource | aws_route53_query_log                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1294 | CKV2_AWS_75 | resource | aws_route53_record                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1295 | CKV2_AWS_75 | resource | aws_route53_resolver_config                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1296 | CKV2_AWS_75 | resource | aws_route53_resolver_dnssec_config                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1297 | CKV2_AWS_75 | resource | aws_route53_resolver_endpoint                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1298 | CKV2_AWS_75 | resource | aws_route53_resolver_firewall_config                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1299 | CKV2_AWS_75 | resource | aws_route53_resolver_firewall_domain_list                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1300 | CKV2_AWS_75 | resource | aws_route53_resolver_firewall_rule                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1301 | CKV2_AWS_75 | resource | aws_route53_resolver_firewall_rule_group                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1302 | CKV2_AWS_75 | resource | aws_route53_resolver_firewall_rule_group_association             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1303 | CKV2_AWS_75 | resource | aws_route53_resolver_query_log_config                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1304 | CKV2_AWS_75 | resource | aws_route53_resolver_query_log_config_association                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1305 | CKV2_AWS_75 | resource | aws_route53_resolver_rule                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1306 | CKV2_AWS_75 | resource | aws_route53_resolver_rule_association                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1307 | CKV2_AWS_75 | resource | aws_route53_traffic_policy                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1308 | CKV2_AWS_75 | resource | aws_route53_traffic_policy_instance                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1309 | CKV2_AWS_75 | resource | aws_route53_vpc_association_authorization                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1310 | CKV2_AWS_75 | resource | aws_route53_zone                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1311 | CKV2_AWS_75 | resource | aws_route53_zone_association                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1312 | CKV2_AWS_75 | resource | aws_route53domains_delegation_signer_record                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1313 | CKV2_AWS_75 | resource | aws_route53domains_domain                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1314 | CKV2_AWS_75 | resource | aws_route53domains_registered_domain                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1315 | CKV2_AWS_75 | resource | aws_route53profiles_association                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1316 | CKV2_AWS_75 | resource | aws_route53profiles_profile                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1317 | CKV2_AWS_75 | resource | aws_route53profiles_resource_association                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1318 | CKV2_AWS_75 | resource | aws_route53recoverycontrolconfig_cluster                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1319 | CKV2_AWS_75 | resource | aws_route53recoverycontrolconfig_control_panel                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1320 | CKV2_AWS_75 | resource | aws_route53recoverycontrolconfig_routing_control                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1321 | CKV2_AWS_75 | resource | aws_route53recoverycontrolconfig_safety_rule                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1322 | CKV2_AWS_75 | resource | aws_route53recoveryreadiness_cell                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1323 | CKV2_AWS_75 | resource | aws_route53recoveryreadiness_readiness_check                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1324 | CKV2_AWS_75 | resource | aws_route53recoveryreadiness_recovery_group                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1325 | CKV2_AWS_75 | resource | aws_route53recoveryreadiness_resource_set                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1326 | CKV2_AWS_75 | resource | aws_route_table                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1327 | CKV2_AWS_75 | resource | aws_route_table_association                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1328 | CKV2_AWS_75 | resource | aws_rum_app_monitor                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1329 | CKV2_AWS_75 | resource | aws_rum_metrics_destination                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1330 | CKV2_AWS_75 | resource | aws_s3_access_point                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1331 | CKV2_AWS_75 | resource | aws_s3_account_public_access_block                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1332 | CKV2_AWS_75 | resource | aws_s3_bucket                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1333 | CKV2_AWS_75 | resource | aws_s3_bucket_accelerate_configuration                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1334 | CKV2_AWS_75 | resource | aws_s3_bucket_acl                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1335 | CKV2_AWS_75 | resource | aws_s3_bucket_analytics_configuration                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1336 | CKV2_AWS_75 | resource | aws_s3_bucket_cors_configuration                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1337 | CKV2_AWS_75 | resource | aws_s3_bucket_intelligent_tiering_configuration                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1338 | CKV2_AWS_75 | resource | aws_s3_bucket_inventory                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1339 | CKV2_AWS_75 | resource | aws_s3_bucket_lifecycle_configuration                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1340 | CKV2_AWS_75 | resource | aws_s3_bucket_logging                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1341 | CKV2_AWS_75 | resource | aws_s3_bucket_metric                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1342 | CKV2_AWS_75 | resource | aws_s3_bucket_notification                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1343 | CKV2_AWS_75 | resource | aws_s3_bucket_object                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1344 | CKV2_AWS_75 | resource | aws_s3_bucket_object_lock_configuration                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1345 | CKV2_AWS_75 | resource | aws_s3_bucket_ownership_controls                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1346 | CKV2_AWS_75 | resource | aws_s3_bucket_policy                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1347 | CKV2_AWS_75 | resource | aws_s3_bucket_public_access_block                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1348 | CKV2_AWS_75 | resource | aws_s3_bucket_replication_configuration                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1349 | CKV2_AWS_75 | resource | aws_s3_bucket_request_payment_configuration                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1350 | CKV2_AWS_75 | resource | aws_s3_bucket_server_side_encryption_configuration               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1351 | CKV2_AWS_75 | resource | aws_s3_bucket_versioning                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1352 | CKV2_AWS_75 | resource | aws_s3_bucket_website_configuration                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1353 | CKV2_AWS_75 | resource | aws_s3_directory_bucket                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1354 | CKV2_AWS_75 | resource | aws_s3_object                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1355 | CKV2_AWS_75 | resource | aws_s3_object_copy                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1356 | CKV2_AWS_75 | resource | aws_s3control_access_grant                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1357 | CKV2_AWS_75 | resource | aws_s3control_access_grants_instance                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1358 | CKV2_AWS_75 | resource | aws_s3control_access_grants_instance_resource_policy             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1359 | CKV2_AWS_75 | resource | aws_s3control_access_grants_location                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1360 | CKV2_AWS_75 | resource | aws_s3control_access_point_policy                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1361 | CKV2_AWS_75 | resource | aws_s3control_bucket                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1362 | CKV2_AWS_75 | resource | aws_s3control_bucket_lifecycle_configuration                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1363 | CKV2_AWS_75 | resource | aws_s3control_bucket_policy                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1364 | CKV2_AWS_75 | resource | aws_s3control_multi_region_access_point                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1365 | CKV2_AWS_75 | resource | aws_s3control_multi_region_access_point_policy                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1366 | CKV2_AWS_75 | resource | aws_s3control_object_lambda_access_point                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1367 | CKV2_AWS_75 | resource | aws_s3control_object_lambda_access_point_policy                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1368 | CKV2_AWS_75 | resource | aws_s3control_storage_lens_configuration                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1369 | CKV2_AWS_75 | resource | aws_s3outposts_endpoint                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1370 | CKV2_AWS_75 | resource | aws_s3tables_namespace                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1371 | CKV2_AWS_75 | resource | aws_s3tables_table                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1372 | CKV2_AWS_75 | resource | aws_s3tables_table_bucket                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1373 | CKV2_AWS_75 | resource | aws_s3tables_table_bucket_policy                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1374 | CKV2_AWS_75 | resource | aws_s3tables_table_policy                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1375 | CKV2_AWS_75 | resource | aws_sagemaker_app                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1376 | CKV2_AWS_75 | resource | aws_sagemaker_app_image_config                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1377 | CKV2_AWS_75 | resource | aws_sagemaker_code_repository                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1378 | CKV2_AWS_75 | resource | aws_sagemaker_data_quality_job_definition                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1379 | CKV2_AWS_75 | resource | aws_sagemaker_device                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1380 | CKV2_AWS_75 | resource | aws_sagemaker_device_fleet                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1381 | CKV2_AWS_75 | resource | aws_sagemaker_domain                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1382 | CKV2_AWS_75 | resource | aws_sagemaker_endpoint                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1383 | CKV2_AWS_75 | resource | aws_sagemaker_endpoint_configuration                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1384 | CKV2_AWS_75 | resource | aws_sagemaker_feature_group                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1385 | CKV2_AWS_75 | resource | aws_sagemaker_flow_definition                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1386 | CKV2_AWS_75 | resource | aws_sagemaker_hub                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1387 | CKV2_AWS_75 | resource | aws_sagemaker_human_task_ui                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1388 | CKV2_AWS_75 | resource | aws_sagemaker_image                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1389 | CKV2_AWS_75 | resource | aws_sagemaker_image_version                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1390 | CKV2_AWS_75 | resource | aws_sagemaker_mlflow_tracking_server                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1391 | CKV2_AWS_75 | resource | aws_sagemaker_model                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1392 | CKV2_AWS_75 | resource | aws_sagemaker_model_package_group                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1393 | CKV2_AWS_75 | resource | aws_sagemaker_model_package_group_policy                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1394 | CKV2_AWS_75 | resource | aws_sagemaker_monitoring_schedule                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1395 | CKV2_AWS_75 | resource | aws_sagemaker_notebook_instance                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1396 | CKV2_AWS_75 | resource | aws_sagemaker_notebook_instance_lifecycle_configuration          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1397 | CKV2_AWS_75 | resource | aws_sagemaker_pipeline                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1398 | CKV2_AWS_75 | resource | aws_sagemaker_project                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1399 | CKV2_AWS_75 | resource | aws_sagemaker_servicecatalog_portfolio_status                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1400 | CKV2_AWS_75 | resource | aws_sagemaker_space                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1401 | CKV2_AWS_75 | resource | aws_sagemaker_studio_lifecycle_config                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1402 | CKV2_AWS_75 | resource | aws_sagemaker_user_profile                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1403 | CKV2_AWS_75 | resource | aws_sagemaker_workforce                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1404 | CKV2_AWS_75 | resource | aws_sagemaker_workteam                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1405 | CKV2_AWS_75 | resource | aws_scheduler_schedule                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1406 | CKV2_AWS_75 | resource | aws_scheduler_schedule_group                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1407 | CKV2_AWS_75 | resource | aws_schemas_discoverer                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1408 | CKV2_AWS_75 | resource | aws_schemas_registry                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1409 | CKV2_AWS_75 | resource | aws_schemas_registry_policy                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1410 | CKV2_AWS_75 | resource | aws_schemas_schema                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1411 | CKV2_AWS_75 | resource | aws_secretsmanager_secret                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1412 | CKV2_AWS_75 | resource | aws_secretsmanager_secret_policy                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1413 | CKV2_AWS_75 | resource | aws_secretsmanager_secret_rotation                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1414 | CKV2_AWS_75 | resource | aws_secretsmanager_secret_version                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1415 | CKV2_AWS_75 | resource | aws_security_group                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1416 | CKV2_AWS_75 | resource | aws_security_group_rule                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1417 | CKV2_AWS_75 | resource | aws_securityhub_account                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1418 | CKV2_AWS_75 | resource | aws_securityhub_action_target                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1419 | CKV2_AWS_75 | resource | aws_securityhub_automation_rule                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1420 | CKV2_AWS_75 | resource | aws_securityhub_configuration_policy                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1421 | CKV2_AWS_75 | resource | aws_securityhub_configuration_policy_association                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1422 | CKV2_AWS_75 | resource | aws_securityhub_finding_aggregator                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1423 | CKV2_AWS_75 | resource | aws_securityhub_insight                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1424 | CKV2_AWS_75 | resource | aws_securityhub_invite_accepter                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1425 | CKV2_AWS_75 | resource | aws_securityhub_member                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1426 | CKV2_AWS_75 | resource | aws_securityhub_organization_admin_account                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1427 | CKV2_AWS_75 | resource | aws_securityhub_organization_configuration                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1428 | CKV2_AWS_75 | resource | aws_securityhub_product_subscription                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1429 | CKV2_AWS_75 | resource | aws_securityhub_standards_control                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1430 | CKV2_AWS_75 | resource | aws_securityhub_standards_control_association                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1431 | CKV2_AWS_75 | resource | aws_securityhub_standards_subscription                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1432 | CKV2_AWS_75 | resource | aws_securitylake_aws_log_source                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1433 | CKV2_AWS_75 | resource | aws_securitylake_custom_log_source                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1434 | CKV2_AWS_75 | resource | aws_securitylake_data_lake                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1435 | CKV2_AWS_75 | resource | aws_securitylake_subscriber                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1436 | CKV2_AWS_75 | resource | aws_securitylake_subscriber_notification                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1437 | CKV2_AWS_75 | resource | aws_serverlessapplicationrepository_cloudformation_stack         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1438 | CKV2_AWS_75 | resource | aws_service_discovery_http_namespace                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1439 | CKV2_AWS_75 | resource | aws_service_discovery_instance                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1440 | CKV2_AWS_75 | resource | aws_service_discovery_private_dns_namespace                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1441 | CKV2_AWS_75 | resource | aws_service_discovery_public_dns_namespace                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1442 | CKV2_AWS_75 | resource | aws_service_discovery_service                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1443 | CKV2_AWS_75 | resource | aws_servicecatalog_budget_resource_association                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1444 | CKV2_AWS_75 | resource | aws_servicecatalog_constraint                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1445 | CKV2_AWS_75 | resource | aws_servicecatalog_organizations_access                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1446 | CKV2_AWS_75 | resource | aws_servicecatalog_portfolio                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1447 | CKV2_AWS_75 | resource | aws_servicecatalog_portfolio_share                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1448 | CKV2_AWS_75 | resource | aws_servicecatalog_principal_portfolio_association               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1449 | CKV2_AWS_75 | resource | aws_servicecatalog_product                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1450 | CKV2_AWS_75 | resource | aws_servicecatalog_product_portfolio_association                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1451 | CKV2_AWS_75 | resource | aws_servicecatalog_provisioned_product                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1452 | CKV2_AWS_75 | resource | aws_servicecatalog_provisioning_artifact                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1453 | CKV2_AWS_75 | resource | aws_servicecatalog_service_action                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1454 | CKV2_AWS_75 | resource | aws_servicecatalog_tag_option                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1455 | CKV2_AWS_75 | resource | aws_servicecatalog_tag_option_resource_association               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1456 | CKV2_AWS_75 | resource | aws_servicecatalogappregistry_application                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1457 | CKV2_AWS_75 | resource | aws_servicecatalogappregistry_attribute_group                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1458 | CKV2_AWS_75 | resource | aws_servicecatalogappregistry_attribute_group_association        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1459 | CKV2_AWS_75 | resource | aws_servicequotas_service_quota                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1460 | CKV2_AWS_75 | resource | aws_servicequotas_template                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1461 | CKV2_AWS_75 | resource | aws_servicequotas_template_association                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1462 | CKV2_AWS_75 | resource | aws_ses_active_receipt_rule_set                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1463 | CKV2_AWS_75 | resource | aws_ses_configuration_set                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1464 | CKV2_AWS_75 | resource | aws_ses_domain_dkim                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1465 | CKV2_AWS_75 | resource | aws_ses_domain_identity                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1466 | CKV2_AWS_75 | resource | aws_ses_domain_identity_verification                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1467 | CKV2_AWS_75 | resource | aws_ses_domain_mail_from                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1468 | CKV2_AWS_75 | resource | aws_ses_email_identity                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1469 | CKV2_AWS_75 | resource | aws_ses_event_destination                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1470 | CKV2_AWS_75 | resource | aws_ses_identity_notification_topic                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1471 | CKV2_AWS_75 | resource | aws_ses_identity_policy                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1472 | CKV2_AWS_75 | resource | aws_ses_receipt_filter                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1473 | CKV2_AWS_75 | resource | aws_ses_receipt_rule                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1474 | CKV2_AWS_75 | resource | aws_ses_receipt_rule_set                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1475 | CKV2_AWS_75 | resource | aws_ses_template                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1476 | CKV2_AWS_75 | resource | aws_sesv2_account_suppression_attributes                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1477 | CKV2_AWS_75 | resource | aws_sesv2_account_vdm_attributes                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1478 | CKV2_AWS_75 | resource | aws_sesv2_configuration_set                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1479 | CKV2_AWS_75 | resource | aws_sesv2_configuration_set_event_destination                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1480 | CKV2_AWS_75 | resource | aws_sesv2_contact_list                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1481 | CKV2_AWS_75 | resource | aws_sesv2_dedicated_ip_assignment                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1482 | CKV2_AWS_75 | resource | aws_sesv2_dedicated_ip_pool                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1483 | CKV2_AWS_75 | resource | aws_sesv2_email_identity                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1484 | CKV2_AWS_75 | resource | aws_sesv2_email_identity_feedback_attributes                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1485 | CKV2_AWS_75 | resource | aws_sesv2_email_identity_mail_from_attributes                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1486 | CKV2_AWS_75 | resource | aws_sesv2_email_identity_policy                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1487 | CKV2_AWS_75 | resource | aws_sfn_activity                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1488 | CKV2_AWS_75 | resource | aws_sfn_alias                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1489 | CKV2_AWS_75 | resource | aws_sfn_state_machine                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1490 | CKV2_AWS_75 | resource | aws_shield_application_layer_automatic_response                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1491 | CKV2_AWS_75 | resource | aws_shield_drt_access_log_bucket_association                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1492 | CKV2_AWS_75 | resource | aws_shield_drt_access_role_arn_association                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1493 | CKV2_AWS_75 | resource | aws_shield_proactive_engagement                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1494 | CKV2_AWS_75 | resource | aws_shield_protection                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1495 | CKV2_AWS_75 | resource | aws_shield_protection_group                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1496 | CKV2_AWS_75 | resource | aws_shield_protection_health_check_association                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1497 | CKV2_AWS_75 | resource | aws_shield_subscription                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1498 | CKV2_AWS_75 | resource | aws_signer_signing_job                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1499 | CKV2_AWS_75 | resource | aws_signer_signing_profile                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1500 | CKV2_AWS_75 | resource | aws_signer_signing_profile_permission                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1501 | CKV2_AWS_75 | resource | aws_simpledb_domain                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1502 | CKV2_AWS_75 | resource | aws_snapshot_create_volume_permission                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1503 | CKV2_AWS_75 | resource | aws_sns_platform_application                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1504 | CKV2_AWS_75 | resource | aws_sns_sms_preferences                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1505 | CKV2_AWS_75 | resource | aws_sns_topic                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1506 | CKV2_AWS_75 | resource | aws_sns_topic_data_protection_policy                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1507 | CKV2_AWS_75 | resource | aws_sns_topic_policy                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1508 | CKV2_AWS_75 | resource | aws_sns_topic_subscription                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1509 | CKV2_AWS_75 | resource | aws_spot_datafeed_subscription                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1510 | CKV2_AWS_75 | resource | aws_spot_fleet_request                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1511 | CKV2_AWS_75 | resource | aws_spot_instance_request                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1512 | CKV2_AWS_75 | resource | aws_sqs_queue                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1513 | CKV2_AWS_75 | resource | aws_sqs_queue_policy                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1514 | CKV2_AWS_75 | resource | aws_sqs_queue_redrive_allow_policy                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1515 | CKV2_AWS_75 | resource | aws_sqs_queue_redrive_policy                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1516 | CKV2_AWS_75 | resource | aws_ssm_activation                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1517 | CKV2_AWS_75 | resource | aws_ssm_association                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1518 | CKV2_AWS_75 | resource | aws_ssm_default_patch_baseline                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1519 | CKV2_AWS_75 | resource | aws_ssm_document                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1520 | CKV2_AWS_75 | resource | aws_ssm_maintenance_window                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1521 | CKV2_AWS_75 | resource | aws_ssm_maintenance_window_target                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1522 | CKV2_AWS_75 | resource | aws_ssm_maintenance_window_task                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1523 | CKV2_AWS_75 | resource | aws_ssm_parameter                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1524 | CKV2_AWS_75 | resource | aws_ssm_patch_baseline                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1525 | CKV2_AWS_75 | resource | aws_ssm_patch_group                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1526 | CKV2_AWS_75 | resource | aws_ssm_resource_data_sync                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1527 | CKV2_AWS_75 | resource | aws_ssm_service_setting                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1528 | CKV2_AWS_75 | resource | aws_ssmcontacts_contact                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1529 | CKV2_AWS_75 | resource | aws_ssmcontacts_contact_channel                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1530 | CKV2_AWS_75 | resource | aws_ssmcontacts_plan                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1531 | CKV2_AWS_75 | resource | aws_ssmcontacts_rotation                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1532 | CKV2_AWS_75 | resource | aws_ssmincidents_replication_set                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1533 | CKV2_AWS_75 | resource | aws_ssmincidents_response_plan                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1534 | CKV2_AWS_75 | resource | aws_ssmquicksetup_configuration_manager                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1535 | CKV2_AWS_75 | resource | aws_ssoadmin_account_assignment                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1536 | CKV2_AWS_75 | resource | aws_ssoadmin_application                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1537 | CKV2_AWS_75 | resource | aws_ssoadmin_application_access_scope                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1538 | CKV2_AWS_75 | resource | aws_ssoadmin_application_assignment                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1539 | CKV2_AWS_75 | resource | aws_ssoadmin_application_assignment_configuration                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1540 | CKV2_AWS_75 | resource | aws_ssoadmin_customer_managed_policy_attachment                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1541 | CKV2_AWS_75 | resource | aws_ssoadmin_instance_access_control_attributes                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1542 | CKV2_AWS_75 | resource | aws_ssoadmin_managed_policy_attachment                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1543 | CKV2_AWS_75 | resource | aws_ssoadmin_permission_set                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1544 | CKV2_AWS_75 | resource | aws_ssoadmin_permission_set_inline_policy                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1545 | CKV2_AWS_75 | resource | aws_ssoadmin_permissions_boundary_attachment                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1546 | CKV2_AWS_75 | resource | aws_ssoadmin_trusted_token_issuer                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1547 | CKV2_AWS_75 | resource | aws_storagegateway_cache                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1548 | CKV2_AWS_75 | resource | aws_storagegateway_cached_iscsi_volume                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1549 | CKV2_AWS_75 | resource | aws_storagegateway_file_system_association                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1550 | CKV2_AWS_75 | resource | aws_storagegateway_gateway                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1551 | CKV2_AWS_75 | resource | aws_storagegateway_nfs_file_share                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1552 | CKV2_AWS_75 | resource | aws_storagegateway_smb_file_share                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1553 | CKV2_AWS_75 | resource | aws_storagegateway_stored_iscsi_volume                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1554 | CKV2_AWS_75 | resource | aws_storagegateway_tape_pool                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1555 | CKV2_AWS_75 | resource | aws_storagegateway_upload_buffer                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1556 | CKV2_AWS_75 | resource | aws_storagegateway_working_storage                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1557 | CKV2_AWS_75 | resource | aws_subnet                                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1558 | CKV2_AWS_75 | resource | aws_swf_domain                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1559 | CKV2_AWS_75 | resource | aws_synthetics_canary                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1560 | CKV2_AWS_75 | resource | aws_synthetics_group                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1561 | CKV2_AWS_75 | resource | aws_synthetics_group_association                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1562 | CKV2_AWS_75 | resource | aws_timestreaminfluxdb_db_instance                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1563 | CKV2_AWS_75 | resource | aws_timestreamquery_scheduled_query                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1564 | CKV2_AWS_75 | resource | aws_timestreamwrite_database                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1565 | CKV2_AWS_75 | resource | aws_timestreamwrite_table                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1566 | CKV2_AWS_75 | resource | aws_transcribe_language_model                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1567 | CKV2_AWS_75 | resource | aws_transcribe_medical_vocabulary                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1568 | CKV2_AWS_75 | resource | aws_transcribe_vocabulary                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1569 | CKV2_AWS_75 | resource | aws_transcribe_vocabulary_filter                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1570 | CKV2_AWS_75 | resource | aws_transfer_access                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1571 | CKV2_AWS_75 | resource | aws_transfer_agreement                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1572 | CKV2_AWS_75 | resource | aws_transfer_certificate                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1573 | CKV2_AWS_75 | resource | aws_transfer_connector                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1574 | CKV2_AWS_75 | resource | aws_transfer_profile                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1575 | CKV2_AWS_75 | resource | aws_transfer_server                                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1576 | CKV2_AWS_75 | resource | aws_transfer_ssh_key                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1577 | CKV2_AWS_75 | resource | aws_transfer_tag                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1578 | CKV2_AWS_75 | resource | aws_transfer_user                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1579 | CKV2_AWS_75 | resource | aws_transfer_workflow                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1580 | CKV2_AWS_75 | resource | aws_verifiedaccess_endpoint                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1581 | CKV2_AWS_75 | resource | aws_verifiedaccess_group                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1582 | CKV2_AWS_75 | resource | aws_verifiedaccess_instance                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1583 | CKV2_AWS_75 | resource | aws_verifiedaccess_instance_logging_configuration                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1584 | CKV2_AWS_75 | resource | aws_verifiedaccess_instance_trust_provider_attachment            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1585 | CKV2_AWS_75 | resource | aws_verifiedaccess_trust_provider                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1586 | CKV2_AWS_75 | resource | aws_verifiedpermissions_identity_source                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1587 | CKV2_AWS_75 | resource | aws_verifiedpermissions_policy                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1588 | CKV2_AWS_75 | resource | aws_verifiedpermissions_policy_store                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1589 | CKV2_AWS_75 | resource | aws_verifiedpermissions_policy_template                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1590 | CKV2_AWS_75 | resource | aws_verifiedpermissions_schema                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1591 | CKV2_AWS_75 | resource | aws_volume_attachment                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1592 | CKV2_AWS_75 | resource | aws_vpc                                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1593 | CKV2_AWS_75 | resource | aws_vpc_block_public_access_exclusion                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1594 | CKV2_AWS_75 | resource | aws_vpc_block_public_access_options                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1595 | CKV2_AWS_75 | resource | aws_vpc_dhcp_options                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1596 | CKV2_AWS_75 | resource | aws_vpc_dhcp_options_association                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1597 | CKV2_AWS_75 | resource | aws_vpc_endpoint                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1598 | CKV2_AWS_75 | resource | aws_vpc_endpoint_connection_accepter                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1599 | CKV2_AWS_75 | resource | aws_vpc_endpoint_connection_notification                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1600 | CKV2_AWS_75 | resource | aws_vpc_endpoint_policy                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1601 | CKV2_AWS_75 | resource | aws_vpc_endpoint_private_dns                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1602 | CKV2_AWS_75 | resource | aws_vpc_endpoint_route_table_association                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1603 | CKV2_AWS_75 | resource | aws_vpc_endpoint_security_group_association                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1604 | CKV2_AWS_75 | resource | aws_vpc_endpoint_service                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1605 | CKV2_AWS_75 | resource | aws_vpc_endpoint_service_allowed_principal                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1606 | CKV2_AWS_75 | resource | aws_vpc_endpoint_service_private_dns_verification                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1607 | CKV2_AWS_75 | resource | aws_vpc_endpoint_subnet_association                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1608 | CKV2_AWS_75 | resource | aws_vpc_ipam                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1609 | CKV2_AWS_75 | resource | aws_vpc_ipam_organization_admin_account                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1610 | CKV2_AWS_75 | resource | aws_vpc_ipam_pool                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1611 | CKV2_AWS_75 | resource | aws_vpc_ipam_pool_cidr                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1612 | CKV2_AWS_75 | resource | aws_vpc_ipam_pool_cidr_allocation                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1613 | CKV2_AWS_75 | resource | aws_vpc_ipam_preview_next_cidr                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1614 | CKV2_AWS_75 | resource | aws_vpc_ipam_resource_discovery                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1615 | CKV2_AWS_75 | resource | aws_vpc_ipam_resource_discovery_association                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1616 | CKV2_AWS_75 | resource | aws_vpc_ipam_scope                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1617 | CKV2_AWS_75 | resource | aws_vpc_ipv4_cidr_block_association                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1618 | CKV2_AWS_75 | resource | aws_vpc_ipv6_cidr_block_association                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1619 | CKV2_AWS_75 | resource | aws_vpc_network_performance_metric_subscription                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1620 | CKV2_AWS_75 | resource | aws_vpc_peering_connection                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1621 | CKV2_AWS_75 | resource | aws_vpc_peering_connection_accepter                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1622 | CKV2_AWS_75 | resource | aws_vpc_peering_connection_options                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1623 | CKV2_AWS_75 | resource | aws_vpc_security_group_egress_rule                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1624 | CKV2_AWS_75 | resource | aws_vpc_security_group_ingress_rule                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1625 | CKV2_AWS_75 | resource | aws_vpc_security_group_vpc_association                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1626 | CKV2_AWS_75 | resource | aws_vpclattice_access_log_subscription                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1627 | CKV2_AWS_75 | resource | aws_vpclattice_auth_policy                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1628 | CKV2_AWS_75 | resource | aws_vpclattice_listener                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1629 | CKV2_AWS_75 | resource | aws_vpclattice_listener_rule                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1630 | CKV2_AWS_75 | resource | aws_vpclattice_resource_configuration                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1631 | CKV2_AWS_75 | resource | aws_vpclattice_resource_gateway                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1632 | CKV2_AWS_75 | resource | aws_vpclattice_resource_policy                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1633 | CKV2_AWS_75 | resource | aws_vpclattice_service                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1634 | CKV2_AWS_75 | resource | aws_vpclattice_service_network                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1635 | CKV2_AWS_75 | resource | aws_vpclattice_service_network_resource_association              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1636 | CKV2_AWS_75 | resource | aws_vpclattice_service_network_service_association               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1637 | CKV2_AWS_75 | resource | aws_vpclattice_service_network_vpc_association                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1638 | CKV2_AWS_75 | resource | aws_vpclattice_target_group                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1639 | CKV2_AWS_75 | resource | aws_vpclattice_target_group_attachment                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1640 | CKV2_AWS_75 | resource | aws_vpn_connection                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1641 | CKV2_AWS_75 | resource | aws_vpn_connection_route                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1642 | CKV2_AWS_75 | resource | aws_vpn_gateway                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1643 | CKV2_AWS_75 | resource | aws_vpn_gateway_attachment                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1644 | CKV2_AWS_75 | resource | aws_vpn_gateway_route_propagation                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1645 | CKV2_AWS_75 | resource | aws_waf_byte_match_set                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1646 | CKV2_AWS_75 | resource | aws_waf_geo_match_set                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1647 | CKV2_AWS_75 | resource | aws_waf_ipset                                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1648 | CKV2_AWS_75 | resource | aws_waf_rate_based_rule                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1649 | CKV2_AWS_75 | resource | aws_waf_regex_match_set                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1650 | CKV2_AWS_75 | resource | aws_waf_regex_pattern_set                                        | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1651 | CKV2_AWS_75 | resource | aws_waf_rule                                                     | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1652 | CKV2_AWS_75 | resource | aws_waf_rule_group                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1653 | CKV2_AWS_75 | resource | aws_waf_size_constraint_set                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1654 | CKV2_AWS_75 | resource | aws_waf_sql_injection_match_set                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1655 | CKV2_AWS_75 | resource | aws_waf_web_acl                                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1656 | CKV2_AWS_75 | resource | aws_waf_xss_match_set                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1657 | CKV2_AWS_75 | resource | aws_wafregional_byte_match_set                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1658 | CKV2_AWS_75 | resource | aws_wafregional_geo_match_set                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1659 | CKV2_AWS_75 | resource | aws_wafregional_ipset                                            | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1660 | CKV2_AWS_75 | resource | aws_wafregional_rate_based_rule                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1661 | CKV2_AWS_75 | resource | aws_wafregional_regex_match_set                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1662 | CKV2_AWS_75 | resource | aws_wafregional_regex_pattern_set                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1663 | CKV2_AWS_75 | resource | aws_wafregional_rule                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1664 | CKV2_AWS_75 | resource | aws_wafregional_rule_group                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1665 | CKV2_AWS_75 | resource | aws_wafregional_size_constraint_set                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1666 | CKV2_AWS_75 | resource | aws_wafregional_sql_injection_match_set                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1667 | CKV2_AWS_75 | resource | aws_wafregional_web_acl                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1668 | CKV2_AWS_75 | resource | aws_wafregional_web_acl_association                              | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1669 | CKV2_AWS_75 | resource | aws_wafregional_xss_match_set                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1670 | CKV2_AWS_75 | resource | aws_wafv2_ip_set                                                 | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1671 | CKV2_AWS_75 | resource | aws_wafv2_regex_pattern_set                                      | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1672 | CKV2_AWS_75 | resource | aws_wafv2_rule_group                                             | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1673 | CKV2_AWS_75 | resource | aws_wafv2_web_acl                                                | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1674 | CKV2_AWS_75 | resource | aws_wafv2_web_acl_association                                    | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1675 | CKV2_AWS_75 | resource | aws_wafv2_web_acl_logging_configuration                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1676 | CKV2_AWS_75 | resource | aws_worklink_fleet                                               | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1677 | CKV2_AWS_75 | resource | aws_worklink_website_certificate_authority_association           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1678 | CKV2_AWS_75 | resource | aws_workspaces_connection_alias                                  | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1679 | CKV2_AWS_75 | resource | aws_workspaces_directory                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1680 | CKV2_AWS_75 | resource | aws_workspaces_ip_group                                          | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1681 | CKV2_AWS_75 | resource | aws_workspaces_workspace                                         | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1682 | CKV2_AWS_75 | resource | aws_xray_encryption_config                                       | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1683 | CKV2_AWS_75 | resource | aws_xray_group                                                   | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |
| 1684 | CKV2_AWS_75 | resource | aws_xray_sampling_rule                                           | Ensure no open CORS policy                                                                                                                                                                               | Cloudformation | [LambdaOpenCorsPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/cloudformation/checks/graph_checks/LambdaOpenCorsPolicy.yaml)                                                                   |


---


